/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHaServices
implements HighAvailabilityServices {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Executor ioExecutor;
    protected final Configuration configuration;
    private final BlobStoreService blobStoreService;
    private RunningJobsRegistry runningJobsRegistry;

    public AbstractHaServices(Configuration config, Executor ioExecutor, BlobStoreService blobStoreService) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)config);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.blobStoreService = (BlobStoreService)Preconditions.checkNotNull((Object)blobStoreService);
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForResourceManager());
    }

    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForDispatcher());
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        return this.createLeaderRetrievalService(this.getLeaderPathForJobManager(jobID));
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return this.createLeaderRetrievalService(this.getLeaderPathForRestServer());
    }

    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        return this.createLeaderElectionService(this.getLeaderPathForResourceManager());
    }

    @Override
    public LeaderElectionService getDispatcherLeaderElectionService() {
        return this.createLeaderElectionService(this.getLeaderPathForDispatcher());
    }

    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        return this.createLeaderElectionService(this.getLeaderPathForJobManager(jobID));
    }

    @Override
    public LeaderElectionService getClusterRestEndpointLeaderElectionService() {
        return this.createLeaderElectionService(this.getLeaderPathForRestServer());
    }

    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() throws Exception {
        return this.createCheckpointRecoveryFactory();
    }

    @Override
    public JobGraphStore getJobGraphStore() throws Exception {
        return this.createJobGraphStore();
    }

    @Override
    public RunningJobsRegistry getRunningJobsRegistry() {
        if (this.runningJobsRegistry == null) {
            this.runningJobsRegistry = this.createRunningJobsRegistry();
        }
        return this.runningJobsRegistry;
    }

    @Override
    public BlobStore createBlobStore() {
        return this.blobStoreService;
    }

    @Override
    public void close() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.close();
        }
        catch (Throwable t) {
            exception = t;
        }
        try {
            this.internalClose();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)("Could not properly close the " + this.getClass().getSimpleName()));
        }
    }

    @Override
    public void closeAndCleanupAllData() throws Exception {
        this.logger.info("Close and clean up all data for {}.", (Object)this.getClass().getSimpleName());
        Throwable exception = null;
        boolean deletedHAData = false;
        try {
            this.internalCleanup();
            deletedHAData = true;
        }
        catch (Exception t) {
            exception = t;
        }
        try {
            this.internalClose();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        try {
            if (deletedHAData) {
                this.blobStoreService.closeAndCleanupAllData();
            } else {
                this.logger.info("Cannot delete HA blobs because we failed to delete the pointers in the HA store.");
                this.blobStoreService.close();
            }
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close and clean up all data of high availability service.");
        }
        this.logger.info("Finished cleaning up the high availability data.");
    }

    @Override
    public void cleanupJobData(JobID jobID) throws Exception {
        this.logger.info("Clean up the high availability data for job {}.", (Object)jobID);
        this.internalCleanupJobData(jobID);
        this.logger.info("Finished cleaning up the high availability data for job {}.", (Object)jobID);
    }

    protected abstract LeaderElectionService createLeaderElectionService(String var1);

    protected abstract LeaderRetrievalService createLeaderRetrievalService(String var1);

    protected abstract CheckpointRecoveryFactory createCheckpointRecoveryFactory() throws Exception;

    protected abstract JobGraphStore createJobGraphStore() throws Exception;

    protected abstract RunningJobsRegistry createRunningJobsRegistry();

    protected abstract void internalClose();

    protected abstract void internalCleanup() throws Exception;

    protected abstract void internalCleanupJobData(JobID var1) throws Exception;

    protected abstract String getLeaderPathForResourceManager();

    protected abstract String getLeaderPathForDispatcher();

    protected abstract String getLeaderPathForJobManager(JobID var1);

    protected abstract String getLeaderPathForRestServer();
}

