/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfOverlay
implements ContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfOverlay.class);
    static final Path TARGET_CONF_DIR = new Path("hadoop/conf");
    final File hadoopConfDir;

    public HadoopConfOverlay(@Nullable File hadoopConfDir) {
        this.hadoopConfDir = hadoopConfDir;
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        if (this.hadoopConfDir == null) {
            return;
        }
        File coreSitePath = new File(this.hadoopConfDir, "core-site.xml");
        File hdfsSitePath = new File(this.hadoopConfDir, "hdfs-site.xml");
        container.getEnvironmentVariables().put("HADOOP_CONF_DIR", TARGET_CONF_DIR.toString());
        container.getFlinkConfiguration().setString("fs.hdfs.hadoopconf", TARGET_CONF_DIR.toString());
        container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(new Path(coreSitePath.toURI())).setDest(new Path(TARGET_CONF_DIR, coreSitePath.getName())).setCachable(true).build());
        container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(new Path(hdfsSitePath.toURI())).setDest(new Path(TARGET_CONF_DIR, hdfsSitePath.getName())).setCachable(true).build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File hadoopConfDir;

        public Builder fromEnvironment(Configuration globalConfiguration) {
            String[] possibleHadoopConfPaths = new String[4];
            possibleHadoopConfPaths[0] = globalConfiguration.getString("fs.hdfs.hadoopconf", null);
            possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
            if (System.getenv("HADOOP_HOME") != null) {
                possibleHadoopConfPaths[2] = System.getenv("HADOOP_HOME") + "/conf";
                possibleHadoopConfPaths[3] = System.getenv("HADOOP_HOME") + "/etc/hadoop";
            }
            for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
                if (possibleHadoopConfPath == null) continue;
                File confPath = new File(possibleHadoopConfPath);
                File coreSitePath = new File(confPath, "core-site.xml");
                File hdfsSitePath = new File(confPath, "hdfs-site.xml");
                if (!coreSitePath.exists() || !hdfsSitePath.exists()) continue;
                this.hadoopConfDir = confPath;
                break;
            }
            if (this.hadoopConfDir == null) {
                LOG.warn("Unable to locate a Hadoop configuration; HDFS will use defaults.");
            }
            return this;
        }

        public HadoopConfOverlay build() {
            return new HadoopConfOverlay(this.hadoopConfDir);
        }
    }
}

