/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class TransientBlobCleanupTask
extends TimerTask {
    private final Logger log;
    private ConcurrentMap<Tuple2<JobID, TransientBlobKey>, Long> blobExpiryTimes;
    private Lock writeLock;
    private File storageDir;

    TransientBlobCleanupTask(ConcurrentMap<Tuple2<JobID, TransientBlobKey>, Long> blobExpiryTimes, Lock writeLock, File storageDir, Logger log) {
        this.blobExpiryTimes = (ConcurrentMap)Preconditions.checkNotNull(blobExpiryTimes);
        this.writeLock = (Lock)Preconditions.checkNotNull((Object)writeLock);
        this.storageDir = (File)Preconditions.checkNotNull((Object)storageDir);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long currentTimeMillis = System.currentTimeMillis();
        Set entries = this.blobExpiryTimes.entrySet();
        for (Map.Entry entry : entries) {
            if (currentTimeMillis < (Long)entry.getValue()) continue;
            JobID jobId = (JobID)((Tuple2)entry.getKey()).f0;
            BlobKey blobKey = (BlobKey)((Tuple2)entry.getKey()).f1;
            File localFile = new File(BlobUtils.getStorageLocationPath(this.storageDir.getAbsolutePath(), jobId, blobKey));
            this.writeLock.lock();
            try {
                try {
                    Files.delete(localFile.toPath());
                }
                catch (Exception e) {
                    this.log.error("Failed to delete local blob " + localFile.getAbsolutePath(), (Throwable)e);
                }
                if (localFile.exists()) continue;
                entries.remove(entry);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

