/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.runtime.throughput.ThroughputEMA;
import org.apache.flink.util.clock.Clock;

public class ThroughputCalculator {
    private static final long NOT_TRACKED = -1L;
    private final Clock clock;
    private final ThroughputEMA throughputEMA;
    private long currentAccumulatedDataSize;
    private long currentMeasurementTime;
    private long measurementStartTime = -1L;

    public ThroughputCalculator(Clock clock, int numberOfSamples) {
        this.clock = clock;
        this.throughputEMA = new ThroughputEMA(numberOfSamples);
    }

    public void incomingDataSize(long receivedDataSize) {
        if (this.measurementStartTime == -1L) {
            this.measurementStartTime = this.clock.absoluteTimeMillis();
        }
        this.currentAccumulatedDataSize += receivedDataSize;
    }

    public void pauseMeasurement(long absoluteTimeMillis) {
        if (this.measurementStartTime != -1L) {
            this.currentMeasurementTime += absoluteTimeMillis - this.measurementStartTime;
        }
        this.measurementStartTime = -1L;
    }

    public void resumeMeasurement(long absoluteTimeMillis) {
        if (this.measurementStartTime == -1L) {
            this.measurementStartTime = absoluteTimeMillis;
        }
    }

    public long calculateThroughput() {
        if (this.measurementStartTime != -1L) {
            long absoluteTimeMillis = this.clock.absoluteTimeMillis();
            this.currentMeasurementTime += absoluteTimeMillis - this.measurementStartTime;
            this.measurementStartTime = absoluteTimeMillis;
        }
        long throughput = this.throughputEMA.calculateThroughput(this.currentAccumulatedDataSize, this.currentMeasurementTime);
        this.currentMeasurementTime = 0L;
        this.currentAccumulatedDataSize = 0L;
        return throughput;
    }
}

