/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;

@PublicEvolving
public class TextInputFormat
extends DelimitedInputFormat<String> {
    private static final long serialVersionUID = 1L;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte NEW_LINE = 10;
    private String charsetName = "UTF-8";

    public TextInputFormat(Path filePath) {
        super(filePath, null);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset must not be null.");
        }
        this.charsetName = charsetName;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        if (this.charsetName == null || !Charset.isSupported(this.charsetName)) {
            throw new RuntimeException("Unsupported charset: " + this.charsetName);
        }
    }

    public String readRecord(String reusable, byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.getDelimiter() != null && this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && offset + numBytes >= 1 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        return new String(bytes, offset, numBytes, this.charsetName);
    }

    public String toString() {
        return "TextInputFormat (" + Arrays.toString(this.getFilePaths()) + ") - " + this.charsetName;
    }

    public boolean supportsMultiPaths() {
        return true;
    }
}

