/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.enums.ApplicationType;
import org.apache.streampark.common.enums.DevelopmentMode;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.common.enums.ResolveOrder;
import org.apache.streampark.common.enums.StorageType;
import org.apache.streampark.common.fs.HdfsOperator;
import org.apache.streampark.common.fs.LfsOperator;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.HadoopUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.exception.ApplicationException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.ObjectUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.bean.AppControl;
import org.apache.streampark.console.core.bean.MavenDependency;
import org.apache.streampark.console.core.entity.AppBuildPipeline;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.enums.AppExistsState;
import org.apache.streampark.console.core.enums.CandidateType;
import org.apache.streampark.console.core.enums.ChangedType;
import org.apache.streampark.console.core.enums.CheckPointType;
import org.apache.streampark.console.core.enums.ConfigFileType;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.enums.Operation;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.mapper.ApplicationMapper;
import org.apache.streampark.console.core.metrics.flink.JobsOverview;
import org.apache.streampark.console.core.runner.EnvInitializer;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.EffectiveService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.console.core.service.ProjectService;
import org.apache.streampark.console.core.service.SavePointService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.service.SettingService;
import org.apache.streampark.console.core.service.VariableService;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.console.core.task.FlinkK8sWatcherWrapper;
import org.apache.streampark.flink.client.FlinkClient;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.core.conf.ParameterCli;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcher;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.packer.pipeline.PipelineStatus;
import org.apache.streampark.flink.packer.pipeline.ShadedBuildResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import scala.Tuple2;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ApplicationServiceImpl
extends ServiceImpl<ApplicationMapper, Application>
implements ApplicationService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    private static final String ERROR_APP_QUEUE_HINT = "Queue label '%s' isn't available for teamId '%d', please add it into the team first.";
    private static final int DEFAULT_HISTORY_RECORD_LIMIT = 25;
    private static final int DEFAULT_HISTORY_POD_TMPL_RECORD_LIMIT = 5;
    private static final Pattern JOB_NAME_PATTERN = Pattern.compile("^[.\\x{4e00}-\\x{9fa5}A-Za-z\\d_\\-\\s]+$");
    private static final Pattern SINGLE_SPACE_PATTERN = Pattern.compile("^\\S+(\\s\\S+)*$");
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private ApplicationConfigService configService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private SavePointService savePointService;
    @Autowired
    private EffectiveService effectiveService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private EnvInitializer envInitializer;
    @Autowired
    private FlinkK8sWatcher flinkK8sWatcher;
    @Autowired
    private AppBuildPipeService appBuildPipeService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private YarnQueueService yarnQueueService;
    @Autowired
    private FlinkK8sWatcherWrapper k8sWatcherWrapper;
    private static final int CPU_NUM = Math.max(2, Runtime.getRuntime().availableProcessors() * 4);
    private final ExecutorService bootstrapExecutor = new ThreadPoolExecutor(CPU_NUM, CPU_NUM * 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-app-bootstrap"));
    private final Map<Long, CompletableFuture<SubmitResponse>> startFutureMap = new ConcurrentHashMap<Long, CompletableFuture<SubmitResponse>>();
    private final Map<Long, CompletableFuture<CancelResponse>> cancelFutureMap = new ConcurrentHashMap<Long, CompletableFuture<CancelResponse>>();

    @PostConstruct
    public void resetOptionState() {
        ((ApplicationMapper)this.baseMapper).resetOptionState();
    }

    @PreDestroy
    public void shutdown() {
        this.bootstrapExecutor.shutdown();
    }

    @Override
    public Map<String, Serializable> dashboard(Long teamId) {
        JobsOverview.Task overview = new JobsOverview.Task();
        Integer totalJmMemory = 0;
        Integer totalTmMemory = 0;
        Integer totalTm = 0;
        Integer totalSlot = 0;
        Integer availableSlot = 0;
        Integer runningJob = 0;
        for (Application app : FlinkAppHttpWatcher.getWatchingApps()) {
            JobsOverview.Task task;
            if (!teamId.equals(app.getTeamId())) continue;
            if (app.getJmMemory() != null) {
                totalJmMemory = totalJmMemory + app.getJmMemory();
            }
            if (app.getTmMemory() != null) {
                totalTmMemory = totalTmMemory + app.getTmMemory() * (app.getTotalTM() == null ? 1 : app.getTotalTM());
            }
            if (app.getTotalTM() != null) {
                totalTm = totalTm + app.getTotalTM();
            }
            if (app.getTotalSlot() != null) {
                totalSlot = totalSlot + app.getTotalSlot();
            }
            if (app.getAvailableSlot() != null) {
                availableSlot = availableSlot + app.getAvailableSlot();
            }
            if (app.getState().intValue() == FlinkAppState.RUNNING.getValue()) {
                Integer n = runningJob;
                Integer n2 = runningJob = Integer.valueOf(runningJob + 1);
            }
            if ((task = app.getOverview()) == null) continue;
            overview.setTotal(overview.getTotal() + task.getTotal());
            overview.setCreated(overview.getCreated() + task.getCreated());
            overview.setScheduled(overview.getScheduled() + task.getScheduled());
            overview.setDeploying(overview.getDeploying() + task.getDeploying());
            overview.setRunning(overview.getRunning() + task.getRunning());
            overview.setFinished(overview.getFinished() + task.getFinished());
            overview.setCanceling(overview.getCanceling() + task.getCanceling());
            overview.setCanceled(overview.getCanceled() + task.getCanceled());
            overview.setFailed(overview.getFailed() + task.getFailed());
            overview.setReconciling(overview.getReconciling() + task.getReconciling());
        }
        FlinkMetricCV k8sMetric = this.flinkK8sWatcher.getAccGroupMetrics(teamId.toString());
        if (k8sMetric != null) {
            totalJmMemory = totalJmMemory + k8sMetric.totalJmMemory();
            totalTmMemory = totalTmMemory + k8sMetric.totalTmMemory();
            totalTm = totalTm + k8sMetric.totalTm();
            totalSlot = totalSlot + k8sMetric.totalSlot();
            availableSlot = availableSlot + k8sMetric.availableSlot();
            runningJob = runningJob + k8sMetric.runningJob();
            overview.setTotal(overview.getTotal() + k8sMetric.totalJob());
            overview.setRunning(overview.getRunning() + k8sMetric.runningJob());
            overview.setFinished(overview.getFinished() + k8sMetric.finishedJob());
            overview.setCanceled(overview.getCanceled() + k8sMetric.cancelledJob());
            overview.setFailed(overview.getFailed() + k8sMetric.failedJob());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(8);
        map.put("task", overview);
        map.put("jmMemory", totalJmMemory);
        map.put("tmMemory", totalTmMemory);
        map.put("totalTM", totalTm);
        map.put("availableSlot", availableSlot);
        map.put("totalSlot", totalSlot);
        map.put("runningJob", runningJob);
        return map;
    }

    @Override
    public String upload(MultipartFile file) throws Exception {
        String fileName;
        File temp = WebUtils.getAppTempDir();
        File saveFile = new File(temp, fileName = FilenameUtils.getName((String)Objects.requireNonNull(file.getOriginalFilename())));
        if (saveFile.exists()) {
            saveFile.delete();
        }
        try {
            file.transferTo(saveFile);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
        return saveFile.getAbsolutePath();
    }

    @Override
    public void toEffective(Application application) {
        FlinkSql flinkSql;
        ApplicationConfig config = this.configService.getLatest(application.getId());
        if (config != null) {
            this.configService.toEffective(application.getId(), config.getId());
        }
        if (application.isFlinkSqlJob() && (flinkSql = this.flinkSqlService.getCandidate(application.getId(), null)) != null) {
            this.flinkSqlService.toEffective(application.getId(), flinkSql.getId());
            this.flinkSqlService.cleanCandidate(flinkSql.getId());
        }
    }

    @Override
    public void revoke(Application appParma) throws ApplicationException {
        Application application = (Application)this.getById(appParma.getId());
        ApiAlertException.throwIfNull(application, String.format("The application id=%s not found, revoke failed.", appParma.getId()));
        application.getFsOperator().delete(application.getAppHome());
        this.backUpService.revoke(application);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(Application::getId, (Object)application.getId());
        if (application.isFlinkSqlJob()) {
            updateWrapper.set(Application::getRelease, (Object)ReleaseState.FAILED.get());
        } else {
            updateWrapper.set(Application::getRelease, (Object)ReleaseState.NEED_RELEASE.get());
        }
        if (!application.isRunning()) {
            updateWrapper.set(Application::getState, (Object)FlinkAppState.REVOKED.getValue());
        }
        ((ApplicationMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delete(Application paramApp) {
        Application application = (Application)this.getById(paramApp.getId());
        this.flinkSqlService.removeApp(application.getId());
        this.applicationLogService.removeApp(application.getId());
        this.configService.removeApp(application.getId());
        this.effectiveService.removeApp(application.getId());
        this.backUpService.removeApp(application);
        this.savePointService.removeApp(application);
        this.appBuildPipeService.removeApp(application.getId());
        this.removeApp(application);
        return true;
    }

    @Override
    public void restart(Application application) throws Exception {
        this.cancel(application);
        this.start(application, false);
    }

    @Override
    public boolean checkEnv(Application appParam) throws ApplicationException {
        Application application = (Application)this.getById(appParam.getId());
        try {
            FlinkCluster flinkCluster;
            boolean conned;
            FlinkEnv flinkEnv = application.getVersionId() != null ? this.flinkEnvService.getByIdOrDefault(application.getVersionId()) : this.flinkEnvService.getDefault();
            if (flinkEnv == null) {
                return false;
            }
            this.envInitializer.checkFlinkEnv(application.getStorageType(), flinkEnv);
            this.envInitializer.storageInitialize(application.getStorageType());
            if ((ExecutionMode.YARN_SESSION.equals((Object)application.getExecutionModeEnum()) || ExecutionMode.REMOTE.equals((Object)application.getExecutionModeEnum())) && !(conned = (flinkCluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId())).verifyClusterConnection())) {
                throw new ApiAlertException("the target cluster is unavailable, please check!");
            }
            return true;
        }
        catch (Exception e) {
            log.error(Utils.stringifyException((Throwable)e));
            throw new ApiDetailException(e);
        }
    }

    @Override
    public boolean checkAlter(Application application) {
        Long appId = application.getId();
        FlinkAppState state = application.getFlinkAppStateEnum();
        if (!FlinkAppState.CANCELED.equals(state)) {
            return false;
        }
        long cancelUserId = FlinkAppHttpWatcher.getCanceledJobUserId(appId);
        long appUserId = application.getUserId();
        return cancelUserId != -1L && cancelUserId != appUserId;
    }

    @Override
    public Map<String, String> getRumtimeConfig(Long id) {
        FlinkEnv flinkEnv;
        Application application = (Application)this.getById(id);
        if (application != null && application.getVersionId() != null && (flinkEnv = this.flinkEnvService.getByIdOrDefault(application.getVersionId())) != null) {
            File yaml = new File(flinkEnv.getFlinkHome().concat("/conf/flink-conf.yaml"));
            HashMap config = PropertiesUtils.loadFlinkConfYaml((File)yaml);
            HashMap dynamicConf = PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties());
            config.putAll(dynamicConf);
            return config;
        }
        return Collections.emptyMap();
    }

    private void removeApp(Application application) {
        Long appId = application.getId();
        this.removeById(appId);
        try {
            application.getFsOperator().delete(application.getWorkspace().APP_WORKSPACE().concat("/").concat(appId.toString()));
            String path = Workspace.of((StorageType)StorageType.HDFS).APP_WORKSPACE().concat("/").concat(appId.toString());
            if (HdfsOperator.exists((String)path)) {
                HdfsOperator.delete((String)path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IPage<Application> page(Application appParam, RestRequest request) {
        if (appParam.getTeamId() == null) {
            return null;
        }
        Page page = MybatisPager.getPage(request);
        if (CommonUtils.notEmpty(new Object[]{appParam.getStateArray()}).booleanValue() && Arrays.stream(appParam.getStateArray()).anyMatch(x -> x.intValue() == FlinkAppState.FINISHED.getValue())) {
            Integer[] newArray = CommonUtils.arrayInsertIndex(appParam.getStateArray(), appParam.getStateArray().length, FlinkAppState.POS_TERMINATED.getValue());
            appParam.setStateArray(newArray);
        }
        ((ApplicationMapper)this.baseMapper).page(page, appParam);
        List records = page.getRecords();
        long now = System.currentTimeMillis();
        List<Long> appIds = records.stream().map(Application::getId).collect(Collectors.toList());
        Map<Long, PipelineStatus> pipeStates = this.appBuildPipeService.listPipelineStatus(appIds);
        records = records.stream().peek(record -> {
            FlinkAppState state;
            if (record.getTracking() == 1 && ((state = record.getFlinkAppStateEnum()) == FlinkAppState.RUNNING || state == FlinkAppState.CANCELLING || state == FlinkAppState.MAPPING)) {
                record.setDuration(now - record.getStartTime().getTime());
            }
            if (record.isKubernetesModeJob()) {
                String restUrl = this.flinkK8sWatcher.getRemoteRestUrl(this.k8sWatcherWrapper.toTrackId((Application)record));
                record.setFlinkRestUrl(restUrl);
            }
        }).peek(record -> {
            if (pipeStates.containsKey(record.getId())) {
                record.setBuildStatus(((PipelineStatus)pipeStates.get(record.getId())).getCode());
            }
        }).peek(record -> {
            AppControl appControl = new AppControl().setAllowBuild(record.getBuildStatus() == null || !PipelineStatus.running.getCode().equals(record.getBuildStatus())).setAllowStart(!record.shouldBeTrack() && PipelineStatus.success.getCode().equals(record.getBuildStatus())).setAllowStop(record.isRunning());
            record.setAppControl(appControl);
        }).collect(Collectors.toList());
        page.setRecords(records);
        return page;
    }

    @Override
    public boolean existsByTeamId(Long teamId) {
        return ((ApplicationMapper)this.baseMapper).existsByTeamId(teamId);
    }

    @Override
    public boolean existsRunningJobByClusterId(Long clusterId) {
        boolean exists = ((ApplicationMapper)this.baseMapper).existsRunningJobByClusterId(clusterId);
        if (exists) {
            return true;
        }
        for (Application application : FlinkAppHttpWatcher.getWatchingApps()) {
            if (!clusterId.equals(application.getFlinkClusterId()) || !FlinkAppState.RUNNING.equals(application.getFlinkAppStateEnum())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existsJobByClusterId(Long clusterId) {
        return ((ApplicationMapper)this.baseMapper).existsJobByClusterId(clusterId);
    }

    @Override
    public boolean existsJobByFlinkEnvId(Long flinkEnvId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Application::getVersionId, (Object)flinkEnvId);
        return ((ApplicationMapper)this.getBaseMapper()).exists((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<String> getRecentK8sNamespace() {
        return ((ApplicationMapper)this.baseMapper).getRecentK8sNamespace(25);
    }

    @Override
    public List<String> getRecentK8sClusterId(Integer executionMode) {
        return ((ApplicationMapper)this.baseMapper).getRecentK8sClusterId(executionMode, 25);
    }

    @Override
    public List<String> getRecentFlinkBaseImage() {
        return ((ApplicationMapper)this.baseMapper).getRecentFlinkBaseImage(25);
    }

    @Override
    public List<String> getRecentK8sPodTemplate() {
        return ((ApplicationMapper)this.baseMapper).getRecentK8sPodTemplate(5);
    }

    @Override
    public List<String> getRecentK8sJmPodTemplate() {
        return ((ApplicationMapper)this.baseMapper).getRecentK8sJmPodTemplate(5);
    }

    @Override
    public List<String> getRecentK8sTmPodTemplate() {
        return ((ApplicationMapper)this.baseMapper).getRecentK8sTmPodTemplate(5);
    }

    @Override
    public List<String> historyUploadJars() {
        return Arrays.stream(LfsOperator.listDir((String)Workspace.of((StorageType)StorageType.LFS).APP_UPLOADS())).filter(File::isFile).sorted(Comparator.comparingLong(File::lastModified).reversed()).map(File::getName).filter(fn -> fn.endsWith(".jar")).limit(25L).collect(Collectors.toList());
    }

    @Override
    public String k8sStartLog(Long id, Integer offset, Integer limit) throws Exception {
        Application application = (Application)this.getById(id);
        ApiAlertException.throwIfNull(application, String.format("The application id=%s can't be found.", id));
        if (ExecutionMode.isKubernetesMode((ExecutionMode)application.getExecutionModeEnum())) {
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> KubernetesDeploymentHelper.watchDeploymentLog((String)application.getK8sNamespace(), (String)application.getJobName(), (String)application.getJobId()));
            return (String)((CompletableFuture)((CompletableFuture)future.exceptionally(e -> {
                String errorLog = String.format("%s/%s_err.log", WebUtils.getAppTempDir().getAbsolutePath(), application.getJobId());
                File file = new File(errorLog);
                if (file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
                return null;
            })).thenApply(path -> {
                if (!future.isDone()) {
                    future.cancel(true);
                }
                if (path != null) {
                    return this.serviceHelper.rollViewLog((String)path, offset, limit);
                }
                return null;
            })).toCompletableFuture().get(5L, TimeUnit.SECONDS);
        }
        throw new ApiAlertException("Job executionMode must be kubernetes-session|kubernetes-application.");
    }

    @Override
    public AppExistsState checkStart(Application appParam) {
        Application application = (Application)this.getById(appParam.getId());
        if (application == null) {
            return AppExistsState.INVALID;
        }
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            boolean exists = !this.getYARNApplication(application.getJobName()).isEmpty();
            return exists ? AppExistsState.IN_YARN : AppExistsState.NO;
        }
        return AppExistsState.NO;
    }

    @Override
    public String getYarnName(Application appParam) {
        String[] args = new String[]{"--name", appParam.getConfig()};
        return ParameterCli.read((String[])args);
    }

    @Override
    public AppExistsState checkExists(Application appParam) {
        if (!this.checkJobName(appParam.getJobName()).booleanValue()) {
            return AppExistsState.INVALID;
        }
        boolean existsByJobName = this.existsByJobName(appParam.getJobName());
        if (appParam.getId() != null) {
            Application app = (Application)this.getById(appParam.getId());
            if (app.getJobName().equals(appParam.getJobName())) {
                return AppExistsState.NO;
            }
            if (existsByJobName) {
                return AppExistsState.IN_DB;
            }
            FlinkAppState state = app.getFlinkAppStateEnum();
            if (state.equals(FlinkAppState.ADDED) || state.equals(FlinkAppState.CREATED) || state.equals(FlinkAppState.FAILED) || state.equals(FlinkAppState.CANCELED) || state.equals(FlinkAppState.LOST) || state.equals(FlinkAppState.KILLED)) {
                if (ExecutionMode.isYarnMode((Integer)appParam.getExecutionMode()) && YarnUtils.isContains((String)appParam.getJobName())) {
                    return AppExistsState.IN_YARN;
                }
                if (ExecutionMode.isKubernetesMode((Integer)appParam.getExecutionMode()) && this.flinkK8sWatcher.checkIsInRemoteCluster(this.k8sWatcherWrapper.toTrackId(app))) {
                    return AppExistsState.IN_KUBERNETES;
                }
            }
        } else {
            if (existsByJobName) {
                return AppExistsState.IN_DB;
            }
            if (ExecutionMode.isYarnMode((Integer)appParam.getExecutionMode()) && YarnUtils.isContains((String)appParam.getJobName())) {
                return AppExistsState.IN_YARN;
            }
            if (ExecutionMode.isKubernetesMode((Integer)appParam.getExecutionMode()) && this.flinkK8sWatcher.checkIsInRemoteCluster(this.k8sWatcherWrapper.toTrackId(appParam))) {
                return AppExistsState.IN_KUBERNETES;
            }
        }
        return AppExistsState.NO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean create(Application appParam) {
        ApiAlertException.throwIfNull(appParam.getTeamId(), "The teamId can't be null. Create application failed.");
        appParam.setBuild(true);
        appParam.setUserId(this.serviceHelper.getUserId());
        appParam.setState(FlinkAppState.ADDED.getValue());
        appParam.setRelease(ReleaseState.NEED_RELEASE.get());
        appParam.setOptionState(OptionState.NONE.getValue());
        Date date = new Date();
        appParam.setCreateTime(date);
        appParam.setModifyTime(date);
        appParam.setDefaultModeIngress(this.settingService.getIngressModeDefault());
        boolean success = this.validateQueueIfNeeded(appParam);
        ApiAlertException.throwIfFalse(success, String.format(ERROR_APP_QUEUE_HINT, appParam.getYarnQueue(), appParam.getTeamId()));
        appParam.doSetHotParams();
        if (appParam.isUploadJob()) {
            String jarPath = WebUtils.getAppTempDir().getAbsolutePath().concat("/").concat(appParam.getJar());
            appParam.setJarCheckSum(FileUtils.checksumCRC32((File)new File(jarPath)));
        }
        if (this.save(appParam)) {
            if (appParam.isFlinkSqlJob()) {
                FlinkSql flinkSql = new FlinkSql(appParam);
                this.flinkSqlService.create(flinkSql);
            }
            if (appParam.getConfig() != null) {
                this.configService.create(appParam, true);
            }
            return true;
        }
        throw new ApiAlertException("create application failed");
    }

    public boolean save(Application entity) {
        String dependency = entity.getDependency();
        if (entity.isFlinkSqlJob()) {
            entity.setDependency(null);
        }
        boolean flag = super.save((Object)entity);
        entity.setDependency(dependency);
        return flag;
    }

    private boolean existsByJobName(String jobName) {
        return ((ApplicationMapper)this.baseMapper).existsByJobName(jobName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long copy(Application appParam) {
        boolean existsByJobName = this.existsByJobName(appParam.getJobName());
        ApiAlertException.throwIfFalse(!existsByJobName, "[StreamPark] Application names can't be repeated, copy application failed.");
        Application oldApp = (Application)this.getById(appParam.getId());
        Application newApp = new Application();
        String jobName = appParam.getJobName();
        newApp.setJobName(jobName);
        newApp.setClusterId(ExecutionMode.isSessionMode((ExecutionMode)oldApp.getExecutionModeEnum()) ? oldApp.getClusterId() : null);
        newApp.setArgs(appParam.getArgs() != null ? appParam.getArgs() : oldApp.getArgs());
        newApp.setVersionId(oldApp.getVersionId());
        newApp.setFlinkClusterId(oldApp.getFlinkClusterId());
        newApp.setRestartSize(oldApp.getRestartSize());
        newApp.setJobType(oldApp.getJobType());
        newApp.setOptions(oldApp.getOptions());
        newApp.setDynamicProperties(oldApp.getDynamicProperties());
        newApp.setResolveOrder(oldApp.getResolveOrder());
        newApp.setExecutionMode(oldApp.getExecutionMode());
        newApp.setFlinkImage(oldApp.getFlinkImage());
        newApp.setK8sNamespace(oldApp.getK8sNamespace());
        newApp.setK8sRestExposedType(oldApp.getK8sRestExposedType());
        newApp.setK8sPodTemplate(oldApp.getK8sPodTemplate());
        newApp.setK8sJmPodTemplate(oldApp.getK8sJmPodTemplate());
        newApp.setK8sTmPodTemplate(oldApp.getK8sTmPodTemplate());
        newApp.setK8sHadoopIntegration(oldApp.getK8sHadoopIntegration());
        newApp.setDescription(oldApp.getDescription());
        newApp.setAlertId(oldApp.getAlertId());
        newApp.setCpFailureAction(oldApp.getCpFailureAction());
        newApp.setCpFailureRateInterval(oldApp.getCpFailureRateInterval());
        newApp.setCpMaxFailureInterval(oldApp.getCpMaxFailureInterval());
        newApp.setMainClass(oldApp.getMainClass());
        newApp.setAppType(oldApp.getAppType());
        newApp.setResourceFrom(oldApp.getResourceFrom());
        newApp.setProjectId(oldApp.getProjectId());
        newApp.setModule(oldApp.getModule());
        newApp.setUserId(this.serviceHelper.getUserId());
        newApp.setState(FlinkAppState.ADDED.getValue());
        newApp.setRelease(ReleaseState.NEED_RELEASE.get());
        newApp.setOptionState(OptionState.NONE.getValue());
        newApp.setHotParams(oldApp.getHotParams());
        Date date = new Date();
        newApp.setCreateTime(date);
        newApp.setModifyTime(date);
        newApp.setJar(oldApp.getJar());
        newApp.setJarCheckSum(oldApp.getJarCheckSum());
        newApp.setTags(oldApp.getTags());
        newApp.setTeamId(oldApp.getTeamId());
        newApp.setDependency(oldApp.getDependency());
        boolean saved = this.save(newApp);
        if (saved) {
            ApplicationConfig copyConfig;
            if (newApp.isFlinkSqlJob()) {
                FlinkSql copyFlinkSql = this.flinkSqlService.getLatestFlinkSql(appParam.getId(), true);
                newApp.setFlinkSql(copyFlinkSql.getSql());
                newApp.setDependency(copyFlinkSql.getDependency());
                FlinkSql flinkSql = new FlinkSql(newApp);
                this.flinkSqlService.create(flinkSql);
            }
            if ((copyConfig = this.configService.getEffective(appParam.getId())) != null) {
                ApplicationConfig config = new ApplicationConfig();
                config.setAppId(newApp.getId());
                config.setFormat(copyConfig.getFormat());
                config.setContent(copyConfig.getContent());
                config.setCreateTime(new Date());
                config.setVersion(1);
                this.configService.save(config);
                this.configService.setLatestOrEffective(true, config.getId(), newApp.getId());
            }
            return newApp.getId();
        }
        throw new ApiAlertException("create application from copy failed, copy source app: " + oldApp.getJobName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(Application appParam) {
        Application application = (Application)this.getById(appParam.getId());
        boolean success = this.validateQueueIfNeeded(application, appParam);
        ApiAlertException.throwIfFalse(success, String.format(ERROR_APP_QUEUE_HINT, appParam.getYarnQueue(), appParam.getTeamId()));
        application.setRelease(ReleaseState.NEED_RELEASE.get());
        if (application.isApacheFlinkCustomCodeJob()) {
            MavenDependency targetDependency;
            MavenDependency thisDependency = MavenDependency.of(appParam.getDependency());
            if (!thisDependency.equals(targetDependency = MavenDependency.of(application.getDependency()))) {
                application.setDependency(appParam.getDependency());
                application.setBuild(true);
            } else if (!ObjectUtils.safeEquals(application.getJar(), appParam.getJar())) {
                application.setBuild(true);
            } else {
                File jarFile = new File(WebUtils.getAppTempDir(), appParam.getJar());
                if (jarFile.exists()) {
                    long checkSum = 0L;
                    try {
                        checkSum = FileUtils.checksumCRC32((File)jarFile);
                    }
                    catch (IOException e) {
                        log.error("Error in checksumCRC32 for {}.", (Object)jarFile);
                        throw new RuntimeException(e);
                    }
                    if (!ObjectUtils.safeEquals(checkSum, application.getJarCheckSum())) {
                        application.setBuild(true);
                    }
                }
            }
        }
        if (!application.getBuild().booleanValue() && !application.getExecutionMode().equals(appParam.getExecutionMode()) && (appParam.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_APPLICATION) || application.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_APPLICATION))) {
            application.setBuild(true);
        }
        if (!(!ExecutionMode.isKubernetesMode((Integer)appParam.getExecutionMode()) || ObjectUtils.safeTrimEquals(application.getK8sRestExposedType(), appParam.getK8sRestExposedType()) && ObjectUtils.safeTrimEquals(application.getK8sJmPodTemplate(), appParam.getK8sJmPodTemplate()) && ObjectUtils.safeTrimEquals(application.getK8sTmPodTemplate(), appParam.getK8sTmPodTemplate()) && ObjectUtils.safeTrimEquals(application.getK8sPodTemplates(), appParam.getK8sPodTemplates()) && ObjectUtils.safeTrimEquals(application.getK8sHadoopIntegration(), appParam.getK8sHadoopIntegration()) && ObjectUtils.safeTrimEquals(application.getFlinkImage(), appParam.getFlinkImage()))) {
            application.setBuild(true);
        }
        if (!ObjectUtils.safeEquals(application.getVersionId(), appParam.getVersionId())) {
            application.setBuild(true);
        }
        appParam.setJobType(application.getJobType());
        application.setJobName(appParam.getJobName());
        application.setVersionId(appParam.getVersionId());
        application.setArgs(appParam.getArgs());
        application.setOptions(appParam.getOptions());
        application.setDynamicProperties(appParam.getDynamicProperties());
        application.setResolveOrder(appParam.getResolveOrder());
        application.setExecutionMode(appParam.getExecutionMode());
        application.setClusterId(appParam.getClusterId());
        application.setFlinkImage(appParam.getFlinkImage());
        application.updateHotParams(appParam);
        application.setK8sRestExposedType(appParam.getK8sRestExposedType());
        application.setK8sPodTemplate(appParam.getK8sPodTemplate());
        application.setK8sJmPodTemplate(appParam.getK8sJmPodTemplate());
        application.setK8sTmPodTemplate(appParam.getK8sTmPodTemplate());
        application.setK8sHadoopIntegration(appParam.getK8sHadoopIntegration());
        application.setModifyTime(new Date());
        application.setDescription(appParam.getDescription());
        application.setAlertId(appParam.getAlertId());
        application.setRestartSize(appParam.getRestartSize());
        application.setCpFailureAction(appParam.getCpFailureAction());
        application.setCpFailureRateInterval(appParam.getCpFailureRateInterval());
        application.setCpMaxFailureInterval(appParam.getCpMaxFailureInterval());
        application.setTags(appParam.getTags());
        switch (appParam.getExecutionModeEnum()) {
            case YARN_APPLICATION: 
            case YARN_PER_JOB: 
            case KUBERNETES_NATIVE_APPLICATION: {
                application.setFlinkClusterId(null);
                if (appParam.getExecutionModeEnum() != ExecutionMode.KUBERNETES_NATIVE_APPLICATION) break;
                application.setK8sNamespace(appParam.getK8sNamespace());
                application.setServiceAccount(appParam.getServiceAccount());
                application.doSetHotParams();
                break;
            }
            case REMOTE: 
            case YARN_SESSION: 
            case KUBERNETES_NATIVE_SESSION: {
                application.setFlinkClusterId(appParam.getFlinkClusterId());
                break;
            }
        }
        if (application.isFlinkSqlJob()) {
            this.updateFlinkSqlJob(application, appParam);
        } else if (application.isStreamParkJob()) {
            this.configService.update(appParam, application.isRunning());
        } else {
            application.setJar(appParam.getJar());
            application.setMainClass(appParam.getMainClass());
        }
        ((ApplicationMapper)this.baseMapper).updateById(application);
        return true;
    }

    private void updateFlinkSqlJob(Application application, Application appParam) {
        FlinkSql effectiveFlinkSql = this.flinkSqlService.getEffective(application.getId(), true);
        if (effectiveFlinkSql == null) {
            effectiveFlinkSql = this.flinkSqlService.getCandidate(application.getId(), CandidateType.NEW);
            this.flinkSqlService.removeById(effectiveFlinkSql.getId());
            FlinkSql sql = new FlinkSql(appParam);
            this.flinkSqlService.create(sql);
            application.setBuild(true);
        } else {
            FlinkSql copySourceFlinkSql = (FlinkSql)this.flinkSqlService.getById(appParam.getSqlId());
            ApiAlertException.throwIfNull(copySourceFlinkSql, "Flink sql is null, update flink sql job failed.");
            copySourceFlinkSql.decode();
            FlinkSql targetFlinkSql = new FlinkSql(appParam);
            ChangedType changedType = copySourceFlinkSql.checkChange(targetFlinkSql);
            log.info("updateFlinkSqlJob changedType: {}", (Object)changedType);
            if (changedType.hasChanged()) {
                FlinkSql historyFlinkSql;
                FlinkSql newFlinkSql = this.flinkSqlService.getCandidate(application.getId(), CandidateType.NEW);
                if (newFlinkSql != null) {
                    this.flinkSqlService.removeById(newFlinkSql.getId());
                }
                if ((historyFlinkSql = this.flinkSqlService.getCandidate(application.getId(), CandidateType.HISTORY)) != null) {
                    this.flinkSqlService.cleanCandidate(historyFlinkSql.getId());
                }
                FlinkSql sql = new FlinkSql(appParam);
                this.flinkSqlService.create(sql);
                if (changedType.isDependencyChanged()) {
                    application.setBuild(true);
                }
            } else {
                boolean versionChanged;
                boolean bl = versionChanged = !effectiveFlinkSql.getId().equals(appParam.getSqlId());
                if (versionChanged) {
                    CandidateType type = CandidateType.HISTORY;
                    this.flinkSqlService.setCandidate(type, appParam.getId(), appParam.getSqlId());
                    application.setRelease(ReleaseState.NEED_ROLLBACK.get());
                    application.setBuild(true);
                }
            }
        }
        this.configService.update(appParam, application.isRunning());
    }

    @Override
    public void updateRelease(Application application) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(Application::getId, (Object)application.getId());
        updateWrapper.set(Application::getRelease, (Object)application.getRelease());
        updateWrapper.set(Application::getBuild, (Object)application.getBuild());
        if (application.getOptionState() != null) {
            updateWrapper.set(Application::getOptionState, (Object)application.getOptionState());
        }
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<Application> getByProjectId(Long id) {
        return ((ApplicationMapper)this.baseMapper).getByProjectId(id);
    }

    @Override
    public List<Application> getByTeamId(Long teamId) {
        return ((ApplicationMapper)this.baseMapper).getByTeamId(teamId);
    }

    @Override
    public List<Application> getByTeamIdAndExecutionModes(Long teamId, @Nonnull Collection<ExecutionMode> executionModes) {
        return ((ApplicationMapper)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Application::getTeamId, (Object)teamId)).in(Application::getExecutionMode, (Collection)executionModes.stream().map(ExecutionMode::getMode).collect(Collectors.toSet())));
    }

    @Override
    public boolean checkBuildAndUpdate(Application application) {
        boolean build = application.getBuild();
        if (!build) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(Application::getId, (Object)application.getId());
            if (application.isRunning()) {
                updateWrapper.set(Application::getRelease, (Object)ReleaseState.NEED_RESTART.get());
            } else {
                updateWrapper.set(Application::getRelease, (Object)ReleaseState.DONE.get());
                updateWrapper.set(Application::getOptionState, (Object)OptionState.NONE.getValue());
            }
            this.update((Wrapper)updateWrapper);
            if (application.isFlinkSqlJob()) {
                FlinkSql newFlinkSql = this.flinkSqlService.getCandidate(application.getId(), CandidateType.NEW);
                if (!application.isNeedRollback() && newFlinkSql != null) {
                    this.backUpService.backup(application, newFlinkSql);
                }
            }
            FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), false);
            if (!application.isRunning() || flinkSql == null) {
                this.toEffective(application);
            }
        }
        return build;
    }

    @Override
    public void forcedStop(Application app) {
        CompletableFuture<SubmitResponse> startFuture = this.startFutureMap.remove(app.getId());
        CompletableFuture<CancelResponse> cancelFuture = this.cancelFutureMap.remove(app.getId());
        Application application = ((ApplicationMapper)this.baseMapper).getApp(app);
        if (application.isKubernetesModeJob()) {
            KubernetesDeploymentHelper.watchPodTerminatedLog((String)application.getK8sNamespace(), (String)application.getJobName(), (String)application.getJobId());
        }
        if (startFuture != null) {
            startFuture.cancel(true);
        }
        if (cancelFuture != null) {
            cancelFuture.cancel(true);
        }
        if (startFuture == null && cancelFuture == null) {
            this.doStopped(app);
        }
    }

    @Override
    public void clean(Application appParam) {
        appParam.setRelease(ReleaseState.DONE.get());
        this.updateRelease(appParam);
    }

    @Override
    public String readConf(Application appParam) throws IOException {
        File file = new File(appParam.getConfig());
        String conf = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(conf.getBytes());
    }

    @Override
    public Application getApp(Application appParam) {
        Application application = ((ApplicationMapper)this.baseMapper).getApp(appParam);
        ApplicationConfig config = this.configService.getEffective(appParam.getId());
        ApplicationConfig applicationConfig = config = config == null ? this.configService.getLatest(appParam.getId()) : config;
        if (config != null) {
            config.setToApplication(application);
        }
        if (application.isFlinkSqlJob()) {
            FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), true);
            if (flinkSql == null) {
                flinkSql = this.flinkSqlService.getCandidate(application.getId(), CandidateType.NEW);
                flinkSql.setSql(DeflaterUtils.unzipString((String)flinkSql.getSql()));
            }
            flinkSql.setToApplication(application);
        } else if (application.isCICDJob()) {
            String path = this.projectService.getAppConfPath(application.getProjectId(), application.getModule());
            application.setConfPath(path);
        }
        if (application.isKubernetesModeJob()) {
            String restUrl = this.flinkK8sWatcher.getRemoteRestUrl(this.k8sWatcherWrapper.toTrackId(application));
            application.setFlinkRestUrl(restUrl);
            long now = System.currentTimeMillis();
            if (application.getTracking() == 1 && application.getStartTime() != null && application.getStartTime().getTime() > 0L) {
                application.setDuration(now - application.getStartTime().getTime());
            }
        }
        application.setByHotParams();
        return application;
    }

    @Override
    public String getMain(Application application) {
        File jarFile;
        if (application.getProjectId() == null) {
            jarFile = new File(application.getJar());
        } else {
            Project project = new Project();
            project.setId(application.getProjectId());
            String modulePath = project.getDistHome().getAbsolutePath().concat("/").concat(application.getModule());
            jarFile = new File(modulePath, application.getJar());
        }
        return Utils.getJarManClass((File)jarFile);
    }

    @Override
    public boolean mapping(Application appParam) {
        boolean mapping = ((ApplicationMapper)this.baseMapper).mapping(appParam);
        Application application = (Application)this.getById(appParam.getId());
        if (application.isKubernetesModeJob()) {
            this.flinkK8sWatcher.doWatching(this.k8sWatcherWrapper.toTrackId(application));
        } else {
            FlinkAppHttpWatcher.doWatching(application);
        }
        return mapping;
    }

    @Override
    public void cancel(Application appParam) throws Exception {
        FlinkAppHttpWatcher.setOptionState(appParam.getId(), OptionState.CANCELLING);
        Application application = (Application)this.getById(appParam.getId());
        application.setState(FlinkAppState.CANCELLING.getValue());
        ApplicationLog applicationLog = new ApplicationLog();
        applicationLog.setOptionName(Operation.CANCEL.getValue());
        applicationLog.setAppId(application.getId());
        applicationLog.setJobManagerUrl(application.getJobManagerUrl());
        applicationLog.setOptionTime(new Date());
        applicationLog.setYarnAppId(application.getClusterId());
        if (appParam.getSavePointed().booleanValue()) {
            FlinkAppHttpWatcher.addSavepoint(application.getId());
            application.setOptionState(OptionState.SAVEPOINTING.getValue());
        } else {
            application.setOptionState(OptionState.CANCELLING.getValue());
        }
        application.setOptionTime(new Date());
        ((ApplicationMapper)this.baseMapper).updateById(application);
        Long userId = this.serviceHelper.getUserId();
        if (!application.getUserId().equals(userId)) {
            FlinkAppHttpWatcher.addCanceledApp(application.getId(), userId);
        }
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(application.getVersionId());
        String customSavepoint = null;
        if (appParam.getSavePointed().booleanValue() && StringUtils.isBlank((CharSequence)(customSavepoint = appParam.getSavePoint()))) {
            customSavepoint = this.savePointService.getSavePointPath(appParam);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (ExecutionMode.isRemoteMode((ExecutionMode)application.getExecutionModeEnum())) {
            FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
            ApiAlertException.throwIfNull(cluster, String.format("The clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            URI activeAddress = cluster.getRemoteURI();
            properties.put(RestOptions.ADDRESS.key(), activeAddress.getHost());
            properties.put(RestOptions.PORT.key(), activeAddress.getPort());
        }
        Tuple2<String, String> clusterIdNamespace = this.getNamespaceClusterId(application);
        String namespace = (String)clusterIdNamespace._1;
        String clusterId = (String)clusterIdNamespace._2;
        CancelRequest cancelRequest = new CancelRequest(flinkEnv.getFlinkVersion(), ExecutionMode.of((Integer)application.getExecutionMode()), properties, clusterId, application.getJobId(), appParam.getSavePointed().booleanValue(), appParam.getDrain().booleanValue(), customSavepoint, namespace);
        Date triggerTime = new Date();
        CompletableFuture<CancelResponse> cancelFuture = CompletableFuture.supplyAsync(() -> FlinkClient.cancel((CancelRequest)cancelRequest), this.bootstrapExecutor);
        this.cancelFutureMap.put(application.getId(), cancelFuture);
        TrackId trackId = application.isKubernetesModeJob() ? this.k8sWatcherWrapper.toTrackId(application) : null;
        cancelFuture.whenComplete((cancelResponse, throwable) -> {
            this.cancelFutureMap.remove(application.getId());
            if (throwable != null) {
                String exception = Utils.stringifyException((Throwable)throwable);
                applicationLog.setException(exception);
                applicationLog.setSuccess(false);
                this.applicationLogService.save(applicationLog);
                if (throwable instanceof CancellationException) {
                    this.doStopped(application);
                } else {
                    log.error("stop flink job failed.", throwable);
                    application.setOptionState(OptionState.NONE.getValue());
                    application.setState(FlinkAppState.FAILED.getValue());
                    this.updateById(application);
                    if (appParam.getSavePointed().booleanValue()) {
                        this.savePointService.expire(application.getId());
                    }
                    if (application.isKubernetesModeJob()) {
                        this.flinkK8sWatcher.unWatching(trackId);
                    } else {
                        FlinkAppHttpWatcher.unWatching(application.getId());
                    }
                }
                return;
            }
            applicationLog.setSuccess(true);
            this.applicationLogService.save(applicationLog);
            if (cancelResponse != null && cancelResponse.savePointDir() != null) {
                String savePointDir = cancelResponse.savePointDir();
                log.info("savePoint path: {}", (Object)savePointDir);
                SavePoint savePoint = new SavePoint();
                savePoint.setPath(savePointDir);
                savePoint.setAppId(application.getId());
                savePoint.setLatest(true);
                savePoint.setType(CheckPointType.SAVEPOINT.get());
                savePoint.setCreateTime(new Date());
                savePoint.setTriggerTime(triggerTime);
                this.savePointService.save(savePoint);
            }
            if (application.isKubernetesModeJob()) {
                this.flinkK8sWatcher.unWatching(trackId);
            }
        });
    }

    @Override
    public String checkSavepointPath(Application appParam) throws Exception {
        String savepointPath = appParam.getSavePoint();
        if (StringUtils.isBlank((CharSequence)savepointPath)) {
            savepointPath = this.savePointService.getSavePointPath(appParam);
        }
        if (StringUtils.isNotBlank((CharSequence)savepointPath)) {
            URI uri = URI.create(savepointPath);
            String scheme = uri.getScheme();
            String pathPart = uri.getPath();
            if (scheme == null) {
                return "This state.savepoints.dir value " + savepointPath + " scheme (hdfs://, file://, etc) of  is null. Please specify the file system scheme explicitly in the URI.";
            }
            if (pathPart == null) {
                return "This state.savepoints.dir value " + savepointPath + " path part to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.";
            }
            if (pathPart.isEmpty() || "/".equals(pathPart)) {
                return "This state.savepoints.dir value " + savepointPath + " Cannot use the root directory for checkpoints.";
            }
            return null;
        }
        return "When custom savepoint is not set, state.savepoints.dir needs to be set in properties or flink-conf.yaml of application";
    }

    @Override
    public void persistMetrics(Application appParam) {
        if (appParam.getFlinkAppStateEnum() == FlinkAppState.RUNNING) {
            appParam.setEndTime(null);
            appParam.setDuration(null);
        }
        ((ApplicationMapper)this.baseMapper).persistMetrics(appParam);
    }

    @Override
    public void starting(Application application) {
        application.setState(FlinkAppState.STARTING.getValue());
        application.setJobManagerUrl(null);
        application.setOptionTime(new Date());
        this.updateById(application);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start(Application appParam, boolean auto) throws Exception {
        String k8sNamespace;
        String k8sClusterId;
        String appConf;
        ExecutionMode executionMode;
        ApplicationLog applicationLog;
        String jobId;
        String flinkUserJar;
        FlinkEnv flinkEnv;
        Application application;
        block29: {
            ApplicationConfig applicationConfig;
            block28: {
                application = (Application)this.getById(appParam.getId());
                Utils.notNull((Object)application);
                if (!application.isCanBeStart()) {
                    throw new ApiAlertException("[StreamPark] The application cannot be started repeatedly.");
                }
                flinkEnv = this.flinkEnvService.getByIdOrDefault(application.getVersionId());
                if (flinkEnv == null) {
                    throw new ApiAlertException("[StreamPark] can no found flink version");
                }
                if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
                    ApiAlertException.throwIfTrue(!this.getYARNApplication(application.getJobName()).isEmpty(), "The same job name is already running in the yarn queue");
                }
                if (!auto) {
                    application.setRestartCount(0);
                } else {
                    if (!application.isNeedRestartOnFailed()) {
                        return;
                    }
                    appParam.setSavePointed(true);
                    application.setRestartCount(application.getRestartCount() + 1);
                }
                this.starting(application);
                application.setAllowNonRestored(appParam.getAllowNonRestored());
                flinkUserJar = null;
                jobId = new JobID().toHexString();
                applicationLog = new ApplicationLog();
                applicationLog.setOptionName(Operation.START.getValue());
                applicationLog.setAppId(application.getId());
                applicationLog.setOptionTime(new Date());
                this.toEffective(application);
                applicationConfig = this.configService.getEffective(application.getId());
                executionMode = ExecutionMode.of((Integer)application.getExecutionMode());
                ApiAlertException.throwIfNull(executionMode, "ExecutionMode can't be null, start application failed.");
                if (!application.isCustomCodeJob()) break block28;
                if (application.isUploadJob()) {
                    appConf = String.format("json://{\"%s\":\"%s\"}", ConfigConst.KEY_FLINK_APPLICATION_MAIN_CLASS(), application.getMainClass());
                } else {
                    switch (application.getApplicationType()) {
                        case STREAMPARK_FLINK: {
                            ConfigFileType fileType = ConfigFileType.of(applicationConfig.getFormat());
                            if (fileType != null && !fileType.equals(ConfigFileType.UNKNOWN)) {
                                appConf = String.format("%s://%s", fileType.getTypeName(), applicationConfig.getContent());
                                break;
                            }
                            throw new IllegalArgumentException("application' config type error,must be ( yaml| properties| hocon )");
                        }
                        case APACHE_FLINK: {
                            appConf = String.format("json://{\"%s\":\"%s\"}", ConfigConst.KEY_FLINK_APPLICATION_MAIN_CLASS(), application.getMainClass());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("[StreamPark] ApplicationType must be (StreamPark flink | Apache flink)... ");
                        }
                    }
                }
                if (!ExecutionMode.YARN_APPLICATION.equals((Object)executionMode)) break block29;
                switch (application.getApplicationType()) {
                    case STREAMPARK_FLINK: {
                        flinkUserJar = String.format("%s/%s", application.getAppHome(), application.getModule().concat(".jar"));
                        break block29;
                    }
                    case APACHE_FLINK: {
                        flinkUserJar = String.format("%s/%s", application.getAppHome(), application.getJar());
                        break block29;
                    }
                    default: {
                        throw new IllegalArgumentException("[StreamPark] ApplicationType must be (StreamPark flink | Apache flink)... ");
                    }
                }
            }
            if (application.isFlinkSqlJob()) {
                FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), false);
                Utils.notNull((Object)flinkSql);
                String sqlDistJar = this.serviceHelper.getSqlClientJar(flinkEnv);
                String string = appConf = applicationConfig == null ? null : String.format("yaml://%s", applicationConfig.getContent());
                if (ExecutionMode.YARN_APPLICATION.equals((Object)executionMode)) {
                    String clientPath = Workspace.remote().APP_CLIENT();
                    flinkUserJar = String.format("%s/%s", clientPath, sqlDistJar);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported...");
            }
        }
        HashMap<String, String> extraParameter = new HashMap<String, String>(0);
        if (application.isFlinkSqlJob()) {
            FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), true);
            String realSql = this.variableService.replaceVariable(application.getTeamId(), flinkSql.getSql());
            flinkSql.setSql(DeflaterUtils.zipString((String)realSql));
            extraParameter.put(ConfigConst.KEY_FLINK_SQL(null), flinkSql.getSql());
        }
        AppBuildPipeline buildPipeline = (AppBuildPipeline)this.appBuildPipeService.getById(application.getId());
        Utils.notNull((Object)buildPipeline);
        Object buildResult = buildPipeline.getBuildResult();
        if (ExecutionMode.YARN_APPLICATION.equals((Object)executionMode)) {
            buildResult = new ShadedBuildResponse(null, flinkUserJar, true);
        }
        String applicationArgs = this.variableService.replaceVariable(application.getTeamId(), application.getArgs());
        FlinkK8sRestExposedType exposedType = null;
        if (application.getExecutionModeEnum() == ExecutionMode.KUBERNETES_NATIVE_SESSION) {
            if (application.getFlinkClusterId() == null) {
                k8sClusterId = application.getClusterId();
                k8sNamespace = application.getK8sNamespace();
                exposedType = application.getK8sRestExposedTypeEnum();
            } else {
                FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
                k8sClusterId = cluster.getClusterId();
                k8sNamespace = cluster.getK8sNamespace();
                exposedType = cluster.getK8sRestExposedTypeEnum();
            }
        } else if (application.getExecutionModeEnum() == ExecutionMode.KUBERNETES_NATIVE_APPLICATION) {
            k8sClusterId = application.getJobName();
            k8sNamespace = application.getK8sNamespace();
            exposedType = application.getK8sRestExposedTypeEnum();
        } else {
            k8sNamespace = null;
            k8sClusterId = null;
        }
        SubmitRequest submitRequest = SubmitRequest.apply((FlinkVersion)flinkEnv.getFlinkVersion(), (ExecutionMode)ExecutionMode.of((Integer)application.getExecutionMode()), this.getProperties(application), (String)flinkEnv.getFlinkConf(), (DevelopmentMode)DevelopmentMode.of((Integer)application.getJobType()), (long)application.getId(), (String)jobId, (String)application.getJobName(), (String)appConf, (ApplicationType)application.getApplicationType(), (String)this.getSavePointed(appParam), (String)applicationArgs, buildResult, extraParameter, (String)k8sClusterId, (String)k8sNamespace, (FlinkK8sRestExposedType)exposedType);
        CompletableFuture<SubmitResponse> future = CompletableFuture.supplyAsync(() -> FlinkClient.submit((SubmitRequest)submitRequest), this.bootstrapExecutor);
        this.startFutureMap.put(application.getId(), future);
        future.whenComplete((response, throwable) -> {
            this.startFutureMap.remove(application.getId());
            if (throwable != null) {
                log.info(" start exception : " + throwable);
                String exception = Utils.stringifyException((Throwable)throwable);
                applicationLog.setException(exception);
                applicationLog.setSuccess(false);
                this.applicationLogService.save(applicationLog);
                if (throwable instanceof CancellationException) {
                    this.doStopped(application);
                } else {
                    Application app = (Application)this.getById(appParam.getId());
                    app.setState(FlinkAppState.FAILED.getValue());
                    app.setOptionState(OptionState.NONE.getValue());
                    this.updateById(app);
                    if (app.isKubernetesModeJob()) {
                        TrackId trackId = this.k8sWatcherWrapper.toTrackId(application);
                        this.flinkK8sWatcher.unWatching(trackId);
                    } else {
                        FlinkAppHttpWatcher.unWatching(appParam.getId());
                    }
                }
                return;
            }
            applicationLog.setSuccess(true);
            if (response.flinkConfig() != null) {
                String tmMemory;
                String jmMemory = (String)response.flinkConfig().get(ConfigConst.KEY_FLINK_JM_PROCESS_MEMORY());
                if (jmMemory != null) {
                    application.setJmMemory(MemorySize.parse((String)jmMemory).getMebiBytes());
                }
                if ((tmMemory = (String)response.flinkConfig().get(ConfigConst.KEY_FLINK_TM_PROCESS_MEMORY())) != null) {
                    application.setTmMemory(MemorySize.parse((String)tmMemory).getMebiBytes());
                }
            }
            if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
                application.setAppId(response.clusterId());
                applicationLog.setYarnAppId(response.clusterId());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{response.jobId()})) {
                application.setJobId(response.jobId());
            }
            if (StringUtils.isNotEmpty((CharSequence)response.jobManagerUrl())) {
                application.setJobManagerUrl(response.jobManagerUrl());
                applicationLog.setJobManagerUrl(response.jobManagerUrl());
            }
            application.setStartTime(new Date());
            application.setEndTime(null);
            if (application.isKubernetesModeJob()) {
                log.info("start job {} on {} success, doWatching...", (Object)application.getJobName(), (Object)application.getExecutionModeEnum().getName());
                application.setRelease(ReleaseState.DONE.get());
                TrackId trackId = this.k8sWatcherWrapper.toTrackId(application);
                this.flinkK8sWatcher.doWatching(trackId);
                if (ExecutionMode.isKubernetesApplicationMode((Integer)application.getExecutionMode())) {
                    try {
                        this.serviceHelper.configureIngress(k8sClusterId, k8sNamespace);
                    }
                    catch (KubernetesClientException e) {
                        log.info("Failed to create ingress, stack info:{}", (Object)e.getMessage());
                        applicationLog.setException(e.getMessage());
                        applicationLog.setSuccess(false);
                        this.applicationLogService.save(applicationLog);
                        application.setState(FlinkAppState.FAILED.getValue());
                        application.setOptionState(OptionState.NONE.getValue());
                    }
                }
            } else {
                FlinkAppHttpWatcher.setOptionState(appParam.getId(), OptionState.STARTING);
                FlinkAppHttpWatcher.doWatching(application);
            }
            this.updateById(application);
            this.applicationLogService.save(applicationLog);
        });
    }

    private Map<String, Object> getProperties(Application application) {
        FlinkCluster cluster;
        Map<String, Object> properties = application.getOptionMap();
        if (ExecutionMode.isRemoteMode((ExecutionMode)application.getExecutionModeEnum())) {
            cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
            ApiAlertException.throwIfNull(cluster, String.format("The clusterId=%s can't be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            URI activeAddress = cluster.getRemoteURI();
            properties.put(RestOptions.ADDRESS.key(), activeAddress.getHost());
            properties.put(RestOptions.PORT.key(), activeAddress.getPort());
        } else if (ExecutionMode.isYarnMode((ExecutionMode)application.getExecutionModeEnum())) {
            if (ExecutionMode.YARN_SESSION.equals((Object)application.getExecutionModeEnum())) {
                cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
                ApiAlertException.throwIfNull(cluster, String.format("The yarn session clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
                properties.put(ConfigConst.KEY_YARN_APP_ID(), cluster.getClusterId());
            } else {
                String yarnQueue = (String)application.getHotParamsMap().get(ConfigConst.KEY_YARN_APP_QUEUE());
                String yarnLabelExpr = (String)application.getHotParamsMap().get(ConfigConst.KEY_YARN_APP_NODE_LABEL());
                Optional.ofNullable(yarnQueue).ifPresent(yq -> properties.put(ConfigConst.KEY_YARN_APP_QUEUE(), yq));
                Optional.ofNullable(yarnLabelExpr).ifPresent(yLabel -> properties.put(ConfigConst.KEY_YARN_APP_NODE_LABEL(), yLabel));
            }
        } else if (ExecutionMode.isKubernetesMode((ExecutionMode)application.getExecutionModeEnum())) {
            properties.put(ConfigConst.KEY_K8S_IMAGE_PULL_POLICY(), "Always");
        }
        if (ExecutionMode.isKubernetesApplicationMode((Integer)application.getExecutionMode())) {
            try {
                HadoopUtils.yarnClient();
                properties.put(JobManagerOptions.ARCHIVE_DIR.key(), Workspace.ARCHIVES_FILE_PATH());
            }
            catch (Exception yarnQueue) {
                // empty catch block
            }
        }
        if (application.getAllowNonRestored().booleanValue()) {
            properties.put(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE.key(), true);
        }
        HashMap dynamicProperties = PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties());
        properties.putAll(dynamicProperties);
        String kerberosKeySvcAccount = ConfigConst.KEY_KERBEROS_SERVICE_ACCOUNT();
        String svcAcc1 = (String)application.getHotParamsMap().get(kerberosKeySvcAccount);
        String svcAcc2 = (String)dynamicProperties.get(kerberosKeySvcAccount);
        if (svcAcc1 != null) {
            properties.put(kerberosKeySvcAccount, svcAcc1);
        } else if (svcAcc2 != null) {
            properties.put(kerberosKeySvcAccount, svcAcc2);
        }
        ResolveOrder resolveOrder = ResolveOrder.of((Integer)application.getResolveOrder());
        if (resolveOrder != null) {
            properties.put(CoreOptions.CLASSLOADER_RESOLVE_ORDER.key(), resolveOrder.getName());
        }
        return properties;
    }

    private void doStopped(Application appParam) {
        Application application = (Application)this.getById(appParam);
        application.setOptionState(OptionState.NONE.getValue());
        application.setState(FlinkAppState.CANCELED.getValue());
        application.setOptionTime(new Date());
        this.updateById(application);
        this.savePointService.expire(application.getId());
        if (application.isKubernetesModeJob()) {
            TrackId id = this.k8sWatcherWrapper.toTrackId(application);
            this.flinkK8sWatcher.doWatching(id);
        } else {
            FlinkAppHttpWatcher.unWatching(application.getId());
        }
        if (ExecutionMode.isYarnMode((ExecutionMode)application.getExecutionModeEnum())) {
            try {
                List<ApplicationReport> applications = this.getYARNApplication(application.getJobName());
                if (!applications.isEmpty()) {
                    YarnClient yarnClient = HadoopUtils.yarnClient();
                    yarnClient.killApplication(applications.get(0).getApplicationId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Boolean checkJobName(String jobName) {
        if (!StringUtils.isEmpty((CharSequence)jobName.trim())) {
            return JOB_NAME_PATTERN.matcher(jobName).matches() && SINGLE_SPACE_PATTERN.matcher(jobName).matches();
        }
        return false;
    }

    private String getSavePointed(Application appParam) {
        if (appParam.getSavePointed().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)appParam.getSavePoint())) {
                SavePoint savePoint = this.savePointService.getLatest(appParam.getId());
                if (savePoint != null) {
                    return savePoint.getPath();
                }
            } else {
                return appParam.getSavePoint();
            }
        }
        return null;
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(Application appParam) {
        this.yarnQueueService.checkQueueLabel(appParam.getExecutionModeEnum(), appParam.getYarnQueue());
        if (this.isYarnNotDefaultQueue(appParam)) {
            return true;
        }
        return this.yarnQueueService.existByTeamIdQueueLabel(appParam.getTeamId(), appParam.getYarnQueue());
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(Application oldApp, Application newApp) {
        this.yarnQueueService.checkQueueLabel(newApp.getExecutionModeEnum(), newApp.getYarnQueue());
        if (this.isYarnNotDefaultQueue(newApp)) {
            return true;
        }
        oldApp.setByHotParams();
        if (ExecutionMode.isYarnPerJobOrAppMode((ExecutionMode)newApp.getExecutionModeEnum()) && StringUtils.equals((CharSequence)oldApp.getYarnQueue(), (CharSequence)newApp.getYarnQueue())) {
            return true;
        }
        return this.yarnQueueService.existByTeamIdQueueLabel(newApp.getTeamId(), newApp.getYarnQueue());
    }

    private boolean isYarnNotDefaultQueue(Application application) {
        return !ExecutionMode.isYarnPerJobOrAppMode((ExecutionMode)application.getExecutionModeEnum()) || this.yarnQueueService.isDefaultQueue(application.getYarnQueue());
    }

    @Override
    public List<ApplicationReport> getYARNApplication(String appName) {
        try {
            YarnClient yarnClient = HadoopUtils.yarnClient();
            HashSet types = Sets.newHashSet((Object[])new String[]{ApplicationType.STREAMPARK_FLINK.getName(), ApplicationType.APACHE_FLINK.getName()});
            EnumSet<YarnApplicationState> states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
            HashSet yarnTag = Sets.newHashSet((Object[])new String[]{"streampark"});
            List applications = yarnClient.getApplications((Set)types, states, (Set)yarnTag);
            return applications.stream().filter(report -> report.getName().equals(appName)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("The yarn api is abnormal. Ensure that yarn is running properly.");
        }
    }

    private Tuple2<String, String> getNamespaceClusterId(Application application) {
        String clusterId = null;
        String k8sNamespace = null;
        switch (application.getExecutionModeEnum()) {
            case YARN_APPLICATION: 
            case YARN_PER_JOB: 
            case YARN_SESSION: {
                clusterId = application.getAppId();
                break;
            }
            case KUBERNETES_NATIVE_APPLICATION: {
                clusterId = application.getJobName();
                k8sNamespace = application.getK8sNamespace();
                break;
            }
            case KUBERNETES_NATIVE_SESSION: {
                if (application.getFlinkClusterId() == null) {
                    clusterId = application.getClusterId();
                    k8sNamespace = application.getK8sNamespace();
                    break;
                }
                FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
                ApiAlertException.throwIfNull(cluster, String.format("The Kubernetes session clusterId=%s can't found, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
                clusterId = cluster.getClusterId();
                k8sNamespace = cluster.getK8sNamespace();
                break;
            }
        }
        return Tuple2.apply(k8sNamespace, (Object)clusterId);
    }
}

