/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client;

import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.impl.KubernetesNativeApplicationClient$;
import org.apache.streampark.flink.client.impl.KubernetesNativeSessionClient$;
import org.apache.streampark.flink.client.impl.LocalClient$;
import org.apache.streampark.flink.client.impl.RemoteClient$;
import org.apache.streampark.flink.client.impl.YarnApplicationClient$;
import org.apache.streampark.flink.client.impl.YarnPerJobClient$;
import org.apache.streampark.flink.client.impl.YarnSessionClient$;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class FlinkClientHandler$ {
    public static final FlinkClientHandler$ MODULE$;
    private final Map<ExecutionMode, FlinkClientTrait> clients;

    static {
        new FlinkClientHandler$();
    }

    public SubmitResponse submit(SubmitRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (option instanceof Some) {
            Some some = (Some)option;
            FlinkClientTrait client = (FlinkClientTrait)some.x();
            SubmitResponse submitResponse = client.submit(request);
            return submitResponse;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ", " submit "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode()})));
    }

    public CancelResponse cancel(CancelRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (option instanceof Some) {
            Some some = (Some)option;
            FlinkClientTrait client = (FlinkClientTrait)some.x();
            CancelResponse cancelResponse = client.cancel(request);
            return cancelResponse;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ", " cancel "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode()})));
    }

    public SavepointResponse triggerSavepoint(TriggerSavepointRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (option instanceof Some) {
            Some some = (Some)option;
            FlinkClientTrait client = (FlinkClientTrait)some.x();
            SavepointResponse savepointResponse = client.triggerSavepoint(request);
            return savepointResponse;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ", " triggerSavepoint "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode()})));
    }

    public DeployResponse deploy(DeployRequest request) {
        block4: {
            DeployResponse deployResponse;
            block3: {
                ExecutionMode executionMode;
                block2: {
                    executionMode = request.executionMode();
                    if (!ExecutionMode.YARN_SESSION.equals(executionMode)) break block2;
                    deployResponse = YarnSessionClient$.MODULE$.deploy(request);
                    break block3;
                }
                if (!ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) break block4;
                deployResponse = KubernetesNativeSessionClient$.MODULE$.deploy(request);
            }
            return deployResponse;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ", " deploy cluster "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode()})));
    }

    public ShutDownResponse shutdown(DeployRequest request) {
        block4: {
            ShutDownResponse shutDownResponse;
            block3: {
                ExecutionMode executionMode;
                block2: {
                    executionMode = request.executionMode();
                    if (!ExecutionMode.YARN_SESSION.equals(executionMode)) break block2;
                    shutDownResponse = YarnSessionClient$.MODULE$.shutdown(request);
                    break block3;
                }
                if (!ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) break block4;
                shutDownResponse = KubernetesNativeSessionClient$.MODULE$.shutdown(request);
            }
            return shutDownResponse;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ", " shutdown cluster "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.executionMode()})));
    }

    private FlinkClientHandler$() {
        MODULE$ = this;
        this.clients = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.LOCAL), (Object)LocalClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.REMOTE), (Object)RemoteClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_APPLICATION), (Object)YarnApplicationClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_SESSION), (Object)YarnSessionClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_PER_JOB), (Object)YarnPerJobClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.KUBERNETES_NATIVE_SESSION), (Object)KubernetesNativeSessionClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.KUBERNETES_NATIVE_APPLICATION), (Object)KubernetesNativeApplicationClient$.MODULE$)}));
    }
}

