/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.core.util;

import com.github.xiaoymin.knife4j.core.model.AnnotationCacheKey;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class AnnotationUtils {
    private static final Map<AnnotationCacheKey, Annotation> findAnnotationCache = new ConcurrentHashMap<AnnotationCacheKey, Annotation>(256);

    public static <A extends Annotation> Optional<A> findAnnotation(Class<?> clazz, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(clazz, annotationType, true);
    }

    public static <A extends Annotation> Optional<A> findAnnotation(Class<?> clazz, Class<A> annotationType, boolean cache) {
        if (annotationType == null) {
            return Optional.empty();
        }
        AnnotationCacheKey cacheKey = new AnnotationCacheKey(clazz, annotationType);
        Annotation result = null;
        if (cache) {
            result = findAnnotationCache.get(cacheKey);
            if (result == null && (result = AnnotationUtils.findOneAnnotation(clazz, annotationType)) != null) {
                findAnnotationCache.put(cacheKey, result);
            }
        } else {
            result = AnnotationUtils.findOneAnnotation(clazz, annotationType);
        }
        return result == null ? Optional.empty() : Optional.ofNullable(result);
    }

    private static <A extends Annotation> Annotation findOneAnnotation(Class<?> clazz, Class<A> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (annotation.annotationType() != annotationType) continue;
            return annotation;
        }
        return null;
    }
}

