/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogClientService {
    private static final Logger log = LoggerFactory.getLogger(LogClientService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String rollViewLog(String path, int offset, int limit) {
        try {
            File file = new File(path);
            if (!file.exists()) return null;
            if (!file.isFile()) return null;
            try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
                List<String> lines = stream.skip(offset).limit(limit).collect(Collectors.toList());
                StringBuilder builder = new StringBuilder();
                lines.forEach(line -> builder.append((String)line).append("\r\n"));
                String string = builder.toString();
                return string;
            }
        }
        catch (Exception e) {
            throw new ApiDetailException("roll view log error: " + e);
        }
    }
}

