/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.GitCredential;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitUtils {
    private GitUtils() {
    }

    public static Git clone(Project project) throws GitAPIException {
        CloneCommand cloneCommand = Git.cloneRepository().setURI(project.getUrl()).setDirectory(project.getAppSource());
        if (project.getBranches() != null) {
            cloneCommand.setBranch("refs/heads/" + project.getBranches());
            cloneCommand.setBranchesToClone(Collections.singletonList("refs/heads/" + project.getBranches()));
        }
        GitUtils.setCredentials(cloneCommand, project);
        return cloneCommand.call();
    }

    public static List<String> getBranchList(Project project) throws GitAPIException {
        LsRemoteCommand command = Git.lsRemoteRepository().setRemote(project.getUrl()).setHeads(true);
        GitUtils.setCredentials(command, project);
        Collection refList = command.call();
        ArrayList<String> branchList = new ArrayList<String>(4);
        for (Ref ref : refList) {
            String refName = ref.getName();
            if (!refName.startsWith("refs/heads/")) continue;
            String branchName = refName.replace("refs/heads/", "");
            branchList.add(branchName);
        }
        return branchList;
    }

    private static void setCredentials(TransportCommand<?, ?> transportCommand, final Project project) {
        GitCredential gitCredential = GitCredential.of(project.getGitCredential());
        switch (gitCredential) {
            case HTTPS: {
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{project.getUserName(), project.getPassword()})) break;
                UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(project.getUserName(), project.getPassword());
                transportCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                break;
            }
            case SSH: {
                transportCommand.setTransportConfigCallback(transport -> {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                        protected void configure(OpenSshConfig.Host hc, Session session) {
                            session.setConfig("StrictHostKeyChecking", "no");
                        }

                        protected JSch createDefaultJSch(FS fs) throws JSchException {
                            String rsaPath;
                            File resFile;
                            String userHome;
                            JSch jSch = super.createDefaultJSch(fs);
                            String prvkeyPath = project.getPrvkeyPath();
                            if (StringUtils.isBlank((CharSequence)prvkeyPath) && (userHome = System.getProperty("user.home")) != null && (resFile = new File(rsaPath = userHome.concat("/.ssh/id_rsa"))).exists()) {
                                prvkeyPath = rsaPath;
                            }
                            if (prvkeyPath == null) {
                                return jSch;
                            }
                            if (StringUtils.isEmpty((CharSequence)project.getPassword())) {
                                jSch.addIdentity(prvkeyPath);
                            } else {
                                jSch.addIdentity(prvkeyPath, project.getPassword());
                            }
                            return jSch;
                        }
                    });
                });
                break;
            }
            default: {
                throw new IllegalStateException("[StreamPark] git setCredentials: unsupported protocol type");
            }
        }
    }
}

