/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.operators.sort.CircularElement;
import org.apache.flink.runtime.operators.sort.ExceptionHandler;
import org.apache.flink.runtime.operators.sort.IndexedSorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.operators.sort.StageRunner;
import org.apache.flink.runtime.operators.sort.ThreadBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortingThread<E>
extends ThreadBase<E> {
    private static final Logger LOG = LoggerFactory.getLogger(SortingThread.class);
    private final IndexedSorter sorter = new QuickSort();

    public SortingThread(@Nullable ExceptionHandler<IOException> exceptionHandler, StageRunner.StageMessageDispatcher<E> dispatcher) {
        super(exceptionHandler, "SortMerger sorting thread", dispatcher);
    }

    @Override
    public void go() throws InterruptedException {
        boolean alive = true;
        while (this.isRunning() && alive) {
            CircularElement element = this.dispatcher.take(StageRunner.SortStage.SORT);
            if (element != CircularElement.EOF_MARKER && element != CircularElement.SPILLING_MARKER) {
                if (element.getBuffer().size() == 0) {
                    element.getBuffer().reset();
                    this.dispatcher.send(StageRunner.SortStage.READ, element);
                    continue;
                }
                LOG.debug("Sorting buffer {}.", (Object)element.getId());
                this.sorter.sort(element.getBuffer());
                LOG.debug("Sorted buffer {}.", (Object)element.getId());
            } else if (element == CircularElement.EOF_MARKER) {
                LOG.debug("Sorting thread done.");
                alive = false;
            }
            this.dispatcher.send(StageRunner.SortStage.SPILL, element);
        }
    }
}

