/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.sort.InMemorySorter;

final class CircularElement<E> {
    private final int id;
    private final InMemorySorter<E> buffer;
    private final List<MemorySegment> memory;
    static final CircularElement<Object> EOF_MARKER = new CircularElement(-1);
    static final CircularElement<Object> SPILLING_MARKER = new CircularElement(-2);

    public CircularElement(int id) {
        this.id = id;
        this.buffer = null;
        this.memory = null;
    }

    public CircularElement(int id, InMemorySorter<E> buffer, List<MemorySegment> memory) {
        this.id = id;
        this.buffer = buffer;
        this.memory = memory;
    }

    public int getId() {
        return this.id;
    }

    public InMemorySorter<E> getBuffer() {
        return this.buffer;
    }

    public List<MemorySegment> getMemory() {
        return this.memory;
    }

    static <T> CircularElement<T> endMarker() {
        CircularElement<Object> c = EOF_MARKER;
        return c;
    }

    static <T> CircularElement<T> spillingMarker() {
        CircularElement<Object> c = SPILLING_MARKER;
        return c;
    }
}

