/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.util.Preconditions;

public class ThroughputEMA {
    private static final long MILLIS_IN_SECOND = 1000L;
    private long currentThroughput;
    private final double alpha;

    public ThroughputEMA(long numberOfSamples) {
        this.alpha = 2.0 / (double)(numberOfSamples + 1L);
    }

    public long calculateThroughput(long dataSize, long time) {
        Preconditions.checkArgument((dataSize >= 0L ? 1 : 0) != 0, (Object)"Size of data should be non negative");
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"Time should be non negative");
        if (time == 0L) {
            return this.currentThroughput;
        }
        this.currentThroughput = this.currentThroughput != 0L ? (long)((double)this.currentThroughput + this.alpha * (double)(ThroughputEMA.instantThroughput(dataSize, time) - this.currentThroughput)) : ThroughputEMA.instantThroughput(dataSize, time);
        return this.currentThroughput;
    }

    static long instantThroughput(long dataSize, long time) {
        return (long)((double)dataSize / (double)time * 1000.0);
    }
}

