/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.rest.messages.ResourceProfileInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.JobIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class SlotInfo
implements ResponseBody,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_RESOURCE = "resource";
    public static final String FIELD_NAME_JOB_ID = "jobId";
    @JsonProperty(value="resource")
    private final ResourceProfileInfo resource;
    @JsonProperty(value="jobId")
    @JsonSerialize(using=JobIDSerializer.class)
    private final JobID jobId;

    @JsonCreator
    public SlotInfo(@JsonDeserialize(using=JobIDDeserializer.class) @JsonProperty(value="jobId") JobID jobId, @JsonProperty(value="resource") ResourceProfileInfo resource) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.resource = (ResourceProfileInfo)Preconditions.checkNotNull((Object)resource);
    }

    public SlotInfo(JobID jobId, ResourceProfile resource) {
        this(jobId, ResourceProfileInfo.fromResrouceProfile(resource));
    }

    @JsonIgnore
    public JobID getJobId() {
        return this.jobId;
    }

    @JsonIgnore
    public ResourceProfileInfo getResource() {
        return this.resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotInfo that = (SlotInfo)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.resource);
    }
}

