/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.flink.kubernetes.K8sPodTemplateFiles;
import org.apache.streampark.flink.kubernetes.PodTemplateType;
import org.apache.streampark.flink.kubernetes.model.K8sPodTemplates;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PodTemplateTool$ {
    public static final PodTemplateTool$ MODULE$;
    private final PodTemplateType KUBERNETES_POD_TEMPLATE;
    private final PodTemplateType KUBERNETES_JM_POD_TEMPLATE;
    private final PodTemplateType KUBERNETES_TM_POD_TEMPLATE;

    static {
        new PodTemplateTool$();
    }

    public PodTemplateType KUBERNETES_POD_TEMPLATE() {
        return this.KUBERNETES_POD_TEMPLATE;
    }

    public PodTemplateType KUBERNETES_JM_POD_TEMPLATE() {
        return this.KUBERNETES_JM_POD_TEMPLATE;
    }

    public PodTemplateType KUBERNETES_TM_POD_TEMPLATE() {
        return this.KUBERNETES_TM_POD_TEMPLATE;
    }

    public K8sPodTemplateFiles preparePodTemplateFiles(String buildWorkspace, K8sPodTemplates podTemplates) {
        File workspaceDir = new File(buildWorkspace);
        Object object = workspaceDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir());
        Map podTempleMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Serializable outputTmplContent = new Serializable(buildWorkspace, podTempleMap){
            public static final long serialVersionUID = 0L;
            private final String buildWorkspace$1;
            private final Map podTempleMap$1;

            public final Object apply(String tmplContent, PodTemplateType podTmpl) {
                BoxedUnit boxedUnit;
                if (new StringOps(Predef$.MODULE$.augmentString(tmplContent)).nonEmpty()) {
                    String outputPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buildWorkspace$1, podTmpl.fileName()}));
                    File outputFile = new File(outputPath);
                    FileUtils.write((File)outputFile, (CharSequence)tmplContent, (String)"UTF-8");
                    boxedUnit = this.podTempleMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)podTmpl.key()), (Object)outputPath));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.buildWorkspace$1 = buildWorkspace$1;
                this.podTempleMap$1 = podTempleMap$1;
            }
        };
        outputTmplContent.apply((Object)podTemplates.podTemplate(), (Object)this.KUBERNETES_POD_TEMPLATE());
        outputTmplContent.apply((Object)podTemplates.jmPodTemplate(), (Object)this.KUBERNETES_JM_POD_TEMPLATE());
        outputTmplContent.apply((Object)podTemplates.tmPodTemplate(), (Object)this.KUBERNETES_TM_POD_TEMPLATE());
        return new K8sPodTemplateFiles((scala.collection.immutable.Map<String, String>)podTempleMap.toMap(Predef$.MODULE$.$conforms()));
    }

    private PodTemplateTool$() {
        MODULE$ = this;
        this.KUBERNETES_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file", "pod-template.yaml");
        this.KUBERNETES_JM_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file.jobmanager", "jm-pod-template.yaml");
        this.KUBERNETES_TM_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file.taskmanager", "tm-pod-template.yaml");
    }
}

