/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class ShutdownHookUtil {
    public static Thread addShutdownHook(AutoCloseable service, String serviceName, Logger logger) {
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(logger);
        Thread shutdownHook = new Thread(() -> {
            try {
                service.close();
            }
            catch (Throwable t) {
                logger.error("Error during shutdown of {} via JVM shutdown hook.", (Object)serviceName, (Object)t);
            }
        }, serviceName + " shutdown hook");
        return ShutdownHookUtil.addShutdownHookThread(shutdownHook, serviceName, logger) ? shutdownHook : null;
    }

    public static boolean addShutdownHookThread(Thread shutdownHook, String serviceName, Logger logger) {
        Preconditions.checkNotNull(shutdownHook);
        Preconditions.checkNotNull(logger);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable t) {
            logger.error("Cannot register shutdown hook that cleanly terminates {}.", (Object)serviceName, (Object)t);
        }
        return false;
    }

    public static void removeShutdownHook(Thread shutdownHook, String serviceName, Logger logger) {
        if (shutdownHook == null || shutdownHook == Thread.currentThread()) {
            return;
        }
        Preconditions.checkNotNull(logger);
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException e) {
            logger.debug("Unable to remove shutdown hook for {}, shutdown already in progress", (Object)serviceName, (Object)e);
        }
        catch (Throwable t) {
            logger.warn("Exception while un-registering {}'s shutdown hook.", (Object)serviceName, (Object)t);
        }
    }

    private ShutdownHookUtil() {
        throw new AssertionError();
    }
}

