/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class LfsOperator$
extends FsOperator
implements Logger {
    public static LfsOperator$ MODULE$;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new LfsOperator$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public boolean exists(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && new File(path).exists();
    }

    @Override
    public void mkdirs(String path) {
        block0: {
            if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))) break block0;
            FileUtils.forceMkdir((File)new File(path));
        }
    }

    @Override
    public void delete(String path) {
        block0: {
            File file;
            if (!Utils$.MODULE$.notEmpty(path) || !(file = new File(path)).exists()) break block0;
            FileUtils.forceDelete((File)file);
        }
    }

    @Override
    public void move(String srcPath, String dstPath) {
        if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
            return;
        }
        File srcFile = new File(srcPath);
        File dstFile = new File(dstPath);
        if (!srcFile.exists()) {
            return;
        }
        String string = srcFile.getCanonicalPath();
        String string2 = dstFile.getCanonicalPath();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return;
        }
        FileUtils.moveToDirectory((File)srcFile, (File)dstFile, (boolean)true);
    }

    @Override
    public void upload(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        if (new File(srcPath).isDirectory()) {
            this.copyDir(srcPath, dstPath, delSrc, overwrite);
        } else {
            this.copy(srcPath, dstPath, delSrc, overwrite);
        }
    }

    @Override
    public void copy(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        block9: {
            boolean shouldCopy;
            boolean bl;
            File file;
            if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
                return;
            }
            File srcFile = new File(srcPath);
            if (!srcFile.exists()) {
                return;
            }
            Predef$.MODULE$.require(srcFile.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("[StreamPark] ").append(srcPath).append(" must be a file.").toString());
            File file2 = new File(dstPath);
            if (file2.exists()) {
                file = file2.isDirectory() ? new File(file2, srcFile.getName()) : file2;
            } else {
                Predef$.MODULE$.require(file2.getParentFile().exists(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] dstPath is invalid and does not exist. Please check");
                file = file2;
            }
            File dstFile = file;
            String string = srcFile.getCanonicalPath();
            String string2 = dstFile.getCanonicalPath();
            Predef$.MODULE$.require(string == null ? string2 != null : !string.equals(string2));
            if (overwrite) {
                bl = true;
            } else if (!dstFile.exists()) {
                bl = true;
            } else {
                String string3 = dstFile.getName();
                String string4 = srcFile.getName();
                bl = (string3 == null ? string4 != null : !string3.equals(string4)) ? true : (shouldCopy = false);
            }
            if (!shouldCopy) break block9;
            FileUtils.copyFile((File)srcFile, (File)dstFile);
            if (delSrc) {
                FileUtils.forceDelete((File)srcFile);
            }
        }
    }

    @Override
    public void copyDir(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        block5: {
            boolean shouldCopy;
            boolean bl;
            if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
                return;
            }
            File srcFile = new File(srcPath);
            if (!srcFile.exists()) {
                return;
            }
            Predef$.MODULE$.require(srcFile.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("[StreamPark] ").append(srcPath).append(" must be a directory.").toString());
            File dstFile = new File(dstPath);
            if (overwrite || !dstFile.exists()) {
                bl = true;
            } else {
                String string = srcFile.getCanonicalPath();
                String string2 = dstFile.getCanonicalPath();
                bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (shouldCopy = false);
            }
            if (!shouldCopy) break block5;
            FileUtils.copyDirectory((File)srcFile, (File)dstFile);
            if (delSrc) {
                FileUtils.deleteDirectory((File)srcFile);
            }
        }
    }

    @Override
    public String fileMd5(String path) {
        Predef$.MODULE$.require(path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] LFsOperator.fileMd5: file must not be null.");
        File file = new File(path);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] LFsOperator.fileMd5: file must exists.");
        return DigestUtils.md5Hex(IOUtils.toByteArray((InputStream)new FileInputStream(path)));
    }

    @Override
    public void mkCleanDirs(String path) {
        this.delete(path);
        this.mkdirs(path);
    }

    public File[] listDir(String path) {
        File[] fileArray;
        if (path == null || path.trim().isEmpty()) {
            fileArray = (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
        } else {
            File file = new File(path);
            File[] fileArray2 = !file.exists() ? (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)) : (file.isFile() ? (File[])((Object[])new File[]{file}) : file.listFiles());
            fileArray = fileArray2;
        }
        return fileArray;
    }

    private LfsOperator$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

