/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ExitCodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN"})
@InterfaceStability.Unstable
public final class ExitUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExitUtil.class.getName());
    private static volatile boolean systemExitDisabled = false;
    private static volatile boolean systemHaltDisabled = false;
    private static volatile ExitException firstExitException;
    private static volatile HaltException firstHaltException;
    public static final String EXIT_EXCEPTION_MESSAGE = "ExitException";
    public static final String HALT_EXCEPTION_MESSAGE = "HaltException";

    private ExitUtil() {
    }

    public static void disableSystemExit() {
        systemExitDisabled = true;
    }

    public static void disableSystemHalt() {
        systemHaltDisabled = true;
    }

    public static boolean terminateCalled() {
        return firstExitException != null;
    }

    public static boolean haltCalled() {
        return firstHaltException != null;
    }

    public static ExitException getFirstExitException() {
        return firstExitException;
    }

    public static HaltException getFirstHaltException() {
        return firstHaltException;
    }

    public static void resetFirstExitException() {
        firstExitException = null;
    }

    public static void resetFirstHaltException() {
        firstHaltException = null;
    }

    public static synchronized void terminate(ExitException ee) throws ExitException {
        int status = ee.getExitCode();
        String msg = ee.getMessage();
        if (status != 0) {
            LOG.debug("Exiting with status {}: {}", new Object[]{status, msg, ee});
            LOG.info("Exiting with status {}: {}", (Object)status, (Object)msg);
        }
        if (systemExitDisabled) {
            LOG.error("Terminate called", (Throwable)ee);
            if (!ExitUtil.terminateCalled()) {
                firstExitException = ee;
            }
            throw ee;
        }
        System.exit(status);
    }

    public static synchronized void halt(HaltException ee) throws HaltException {
        int status = ee.getExitCode();
        String msg = ee.getMessage();
        try {
            if (status != 0) {
                LOG.info("Halt with status {}: {}", new Object[]{status, msg, ee});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (systemHaltDisabled) {
            LOG.error("Halt called", (Throwable)ee);
            if (!ExitUtil.haltCalled()) {
                firstHaltException = ee;
            }
            throw ee;
        }
        Runtime.getRuntime().halt(status);
    }

    public static void terminate(int status, Throwable t) throws ExitException {
        if (t instanceof ExitException) {
            ExitUtil.terminate((ExitException)t);
        } else {
            ExitUtil.terminate(new ExitException(status, t));
        }
    }

    public static void halt(int status, Throwable t) throws HaltException {
        if (t instanceof HaltException) {
            ExitUtil.halt((HaltException)t);
        } else {
            ExitUtil.halt(new HaltException(status, t));
        }
    }

    public static void terminate(int status) throws ExitException {
        ExitUtil.terminate(status, EXIT_EXCEPTION_MESSAGE);
    }

    public static void terminate(int status, String msg) throws ExitException {
        ExitUtil.terminate(new ExitException(status, msg));
    }

    public static void halt(int status) throws HaltException {
        ExitUtil.halt(status, HALT_EXCEPTION_MESSAGE);
    }

    public static void halt(int status, String message) throws HaltException {
        ExitUtil.halt(new HaltException(status, message));
    }

    public static void haltOnOutOfMemory(OutOfMemoryError oome) {
        try {
            System.err.println("Halting due to Out Of Memory Error...");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().halt(-1);
    }

    public static class HaltException
    extends RuntimeException
    implements ExitCodeProvider {
        private static final long serialVersionUID = 1L;
        public final int status;

        public HaltException(int status, Throwable cause) {
            super(cause);
            this.status = status;
        }

        public HaltException(int status, String msg) {
            super(msg);
            this.status = status;
        }

        public HaltException(int status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        @Override
        public int getExitCode() {
            return this.status;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message == null) {
                message = super.toString();
            }
            return Integer.toString(this.status) + ": " + message;
        }
    }

    public static class ExitException
    extends RuntimeException
    implements ExitCodeProvider {
        private static final long serialVersionUID = 1L;
        public final int status;

        public ExitException(int status, String msg) {
            super(msg);
            this.status = status;
        }

        public ExitException(int status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        public ExitException(int status, Throwable cause) {
            super(cause);
            this.status = status;
        }

        @Override
        public int getExitCode() {
            return this.status;
        }

        @Override
        public String toString() {
            String message = this.getMessage();
            if (message == null) {
                message = super.toString();
            }
            return Integer.toString(this.status) + ": " + message;
        }
    }
}

