/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.topology.VertexID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexID
implements VertexID {
    private final JobVertexID jobVertexId;
    private final int subtaskIndex;

    public ExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
        Preconditions.checkArgument((subtaskIndex >= 0 ? 1 : 0) != 0, (Object)"subtaskIndex must be greater than or equal to 0");
        this.jobVertexId = (JobVertexID)Preconditions.checkNotNull((Object)jobVertexId);
        this.subtaskIndex = subtaskIndex;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public void writeTo(ByteBuf buf) {
        this.jobVertexId.writeTo(buf);
        buf.writeInt(this.subtaskIndex);
    }

    public static ExecutionVertexID fromByteBuf(ByteBuf buf) {
        JobVertexID jobVertexID = JobVertexID.fromByteBuf(buf);
        int subtaskIndex = buf.readInt();
        return new ExecutionVertexID(jobVertexID, subtaskIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionVertexID that = (ExecutionVertexID)o;
        return this.subtaskIndex == that.subtaskIndex && this.jobVertexId.equals(that.jobVertexId);
    }

    public int hashCode() {
        int result = this.jobVertexId.hashCode();
        result = 31 * result + this.subtaskIndex;
        return result;
    }

    public String toString() {
        return this.jobVertexId + "_" + this.subtaskIndex;
    }
}

