/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.Preconditions;

public class UpdateSchedulerNgOnInternalFailuresListener
implements InternalFailuresListener {
    private final SchedulerNG schedulerNg;

    public UpdateSchedulerNgOnInternalFailuresListener(SchedulerNG schedulerNg) {
        this.schedulerNg = (SchedulerNG)Preconditions.checkNotNull((Object)schedulerNg);
    }

    @Override
    public void notifyTaskFailure(ExecutionAttemptID attemptId, Throwable t, boolean cancelTask, boolean releasePartitions) {
        TaskExecutionState state = new TaskExecutionState(attemptId, ExecutionState.FAILED, t);
        this.schedulerNg.updateTaskExecutionState(new TaskExecutionStateTransition(state, cancelTask, releasePartitions));
    }

    @Override
    public void notifyGlobalFailure(Throwable t) {
        this.schedulerNg.handleGlobalFailure(t);
    }
}

