/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class SchemaPropertyDeprecatingConverter
implements ModelConverter {
    private static final List<Class<? extends Annotation>> DEPRECATED_ANNOTATIONS = Collections.synchronizedList(new ArrayList());

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            Schema resolvedSchema = chain.next().resolve(type, context, chain);
            if (type.isSchemaProperty() && SchemaPropertyDeprecatingConverter.containsDeprecatedAnnotation(type.getCtxAnnotations())) {
                resolvedSchema.setDeprecated(Boolean.valueOf(true));
            }
            return resolvedSchema;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsDeprecatedAnnotation(Annotation[] annotations) {
        if (annotations == null) return false;
        if (!Stream.of(annotations).map(Annotation::annotationType).anyMatch(DEPRECATED_ANNOTATIONS::contains)) return false;
        return true;
    }

    public static void addDeprecatedType(Class<? extends Annotation> cls) {
        DEPRECATED_ANNOTATIONS.add(cls);
    }

    public static boolean isDeprecated(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        boolean deprecatedMethod = DEPRECATED_ANNOTATIONS.stream().anyMatch(annoClass -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, (Class)annoClass) != null);
        boolean deprecatedClass = DEPRECATED_ANNOTATIONS.stream().anyMatch(annoClass -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaringClass, (Class)annoClass) != null);
        return deprecatedClass || deprecatedMethod;
    }

    static {
        DEPRECATED_ANNOTATIONS.add(Deprecated.class);
    }
}

