/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.core.conf;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FlinkRunOption$ {
    public static final FlinkRunOption$ MODULE$;
    private final Option HELP_OPTION;
    private final Option JAR_OPTION;
    private final Option CLASS_OPTION;
    private final Option CLASSPATH_OPTION;
    private final Option PARALLELISM_OPTION;
    private final Option DETACHED_OPTION;
    private final Option SHUTDOWN_IF_ATTACHED_OPTION;
    private final Option YARN_DETACHED_OPTION;
    private final Option ARGS_OPTION;
    private final Option ADDRESS_OPTION;
    private final Option SAVEPOINT_PATH_OPTION;
    private final Option SAVEPOINT_ALLOW_NON_RESTORED_OPTION;
    private final Option SAVEPOINT_DISPOSE_OPTION;
    private final Option RUNNING_OPTION;
    private final Option SCHEDULED_OPTION;
    private final Option ALL_OPTION;
    private final Option ZOOKEEPER_NAMESPACE_OPTION;
    private final Option CANCEL_WITH_SAVEPOINT_OPTION;
    private final Option STOP_WITH_SAVEPOINT_PATH;
    private final Option STOP_AND_DRAIN;
    private final Option PY_OPTION;
    private final Option PYFILES_OPTION;
    private final Option PYMODULE_OPTION;
    private final Option PYREQUIREMENTS_OPTION;
    private final Option PYARCHIVE_OPTION;
    private final Option PYEXEC_OPTION;
    private final Option DYNAMIC_PROPERTIES;
    private final Option EXECUTOR_OPTION;
    private final Option TARGET_OPTION;

    static {
        new FlinkRunOption$();
    }

    public Option HELP_OPTION() {
        return this.HELP_OPTION;
    }

    public Option JAR_OPTION() {
        return this.JAR_OPTION;
    }

    public Option CLASS_OPTION() {
        return this.CLASS_OPTION;
    }

    public Option CLASSPATH_OPTION() {
        return this.CLASSPATH_OPTION;
    }

    public Option PARALLELISM_OPTION() {
        return this.PARALLELISM_OPTION;
    }

    public Option DETACHED_OPTION() {
        return this.DETACHED_OPTION;
    }

    public Option SHUTDOWN_IF_ATTACHED_OPTION() {
        return this.SHUTDOWN_IF_ATTACHED_OPTION;
    }

    public Option YARN_DETACHED_OPTION() {
        return this.YARN_DETACHED_OPTION;
    }

    public Option ARGS_OPTION() {
        return this.ARGS_OPTION;
    }

    public Option ADDRESS_OPTION() {
        return this.ADDRESS_OPTION;
    }

    public Option SAVEPOINT_PATH_OPTION() {
        return this.SAVEPOINT_PATH_OPTION;
    }

    public Option SAVEPOINT_ALLOW_NON_RESTORED_OPTION() {
        return this.SAVEPOINT_ALLOW_NON_RESTORED_OPTION;
    }

    public Option SAVEPOINT_DISPOSE_OPTION() {
        return this.SAVEPOINT_DISPOSE_OPTION;
    }

    public Option RUNNING_OPTION() {
        return this.RUNNING_OPTION;
    }

    public Option SCHEDULED_OPTION() {
        return this.SCHEDULED_OPTION;
    }

    public Option ALL_OPTION() {
        return this.ALL_OPTION;
    }

    public Option ZOOKEEPER_NAMESPACE_OPTION() {
        return this.ZOOKEEPER_NAMESPACE_OPTION;
    }

    public Option CANCEL_WITH_SAVEPOINT_OPTION() {
        return this.CANCEL_WITH_SAVEPOINT_OPTION;
    }

    public Option STOP_WITH_SAVEPOINT_PATH() {
        return this.STOP_WITH_SAVEPOINT_PATH;
    }

    public Option STOP_AND_DRAIN() {
        return this.STOP_AND_DRAIN;
    }

    public Option PY_OPTION() {
        return this.PY_OPTION;
    }

    public Option PYFILES_OPTION() {
        return this.PYFILES_OPTION;
    }

    public Option PYMODULE_OPTION() {
        return this.PYMODULE_OPTION;
    }

    public Option PYREQUIREMENTS_OPTION() {
        return this.PYREQUIREMENTS_OPTION;
    }

    public Option PYARCHIVE_OPTION() {
        return this.PYARCHIVE_OPTION;
    }

    public Option PYEXEC_OPTION() {
        return this.PYEXEC_OPTION;
    }

    public Option DYNAMIC_PROPERTIES() {
        return this.DYNAMIC_PROPERTIES;
    }

    public Option EXECUTOR_OPTION() {
        return this.EXECUTOR_OPTION;
    }

    public Option TARGET_OPTION() {
        return this.TARGET_OPTION;
    }

    /*
     * WARNING - void declaration
     */
    public Options allOptions() {
        void var3_3;
        Options commOptions = this.getRunCommandOptions();
        Options yarnOptions = this.getYARNOptions();
        Options resultOptions = new Options();
        JavaConversions$.MODULE$.collectionAsScalaIterable(commOptions.getOptions()).foreach((Function1)new Serializable(resultOptions){
            public static final long serialVersionUID = 0L;
            private final Options resultOptions$1;

            public final Options apply(Option x$1) {
                return this.resultOptions$1.addOption(x$1);
            }
            {
                this.resultOptions$1 = resultOptions$1;
            }
        });
        ((IterableLike)JavaConversions$.MODULE$.collectionAsScalaIterable(yarnOptions.getOptions()).filter((Function1)new Serializable(resultOptions){
            public static final long serialVersionUID = 0L;
            private final Options resultOptions$1;

            public final boolean apply(Option x) {
                return !this.resultOptions$1.hasOption(x.getOpt());
            }
            {
                this.resultOptions$1 = resultOptions$1;
            }
        })).foreach((Function1)new Serializable(resultOptions){
            public static final long serialVersionUID = 0L;
            private final Options resultOptions$1;

            public final Options apply(Option x$1) {
                return this.resultOptions$1.addOption(x$1);
            }
            {
                this.resultOptions$1 = resultOptions$1;
            }
        });
        return var3_3;
    }

    public Options getRunCommandOptions() {
        Options options = this.buildGeneralOptions(new Options());
        options = this.getProgramSpecificOptions(options);
        options.addOption(this.SAVEPOINT_PATH_OPTION());
        options.addOption(this.EXECUTOR_OPTION());
        options.addOption(this.TARGET_OPTION());
        options.addOption(this.SAVEPOINT_ALLOW_NON_RESTORED_OPTION());
        return options.addOption(this.DYNAMIC_PROPERTIES());
    }

    /*
     * WARNING - void declaration
     */
    public Options getYARNOptions() {
        void var1_1;
        Options allOptions2 = new Options();
        allOptions2.addOption(this.DETACHED_OPTION());
        allOptions2.addOption(this.YARN_DETACHED_OPTION());
        return var1_1;
    }

    public Options buildGeneralOptions(Options options) {
        options.addOption(this.HELP_OPTION());
        options.addOption(new Option("v", "verbose", false, "This option is deprecated."));
        return options;
    }

    public Options getProgramSpecificOptions(Options options) {
        options.addOption(this.JAR_OPTION());
        options.addOption(this.CLASS_OPTION());
        options.addOption(this.ADDRESS_OPTION());
        options.addOption(this.CLASSPATH_OPTION());
        options.addOption(this.PARALLELISM_OPTION());
        options.addOption(this.ARGS_OPTION());
        options.addOption(this.DETACHED_OPTION());
        options.addOption(this.SHUTDOWN_IF_ATTACHED_OPTION());
        options.addOption(this.YARN_DETACHED_OPTION());
        options.addOption(this.PY_OPTION());
        options.addOption(this.PYFILES_OPTION());
        options.addOption(this.PYMODULE_OPTION());
        options.addOption(this.PYREQUIREMENTS_OPTION());
        options.addOption(this.PYARCHIVE_OPTION());
        options.addOption(this.PYEXEC_OPTION());
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public Options mergeOptions(Options optionsA, Options optionsB) {
        void var3_3;
        Options resultOptions = new Options();
        Predef$.MODULE$.require(optionsA != null);
        Predef$.MODULE$.require(optionsB != null);
        JavaConversions$.MODULE$.collectionAsScalaIterable(optionsA.getOptions()).foreach((Function1)new Serializable(resultOptions){
            public static final long serialVersionUID = 0L;
            private final Options resultOptions$2;

            public final Options apply(Option x$1) {
                return this.resultOptions$2.addOption(x$1);
            }
            {
                this.resultOptions$2 = resultOptions$2;
            }
        });
        JavaConversions$.MODULE$.collectionAsScalaIterable(optionsB.getOptions()).foreach((Function1)new Serializable(resultOptions){
            public static final long serialVersionUID = 0L;
            private final Options resultOptions$2;

            public final Options apply(Option x$1) {
                return this.resultOptions$2.addOption(x$1);
            }
            {
                this.resultOptions$2 = resultOptions$2;
            }
        });
        return var3_3;
    }

    public CommandLine parse(Options options, String[] args, Boolean stopAtNonOptions) {
        DefaultParser parser = new DefaultParser();
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(options, args, stopAtNonOptions, parser){
            public static final long serialVersionUID = 0L;
            private final Options options$1;
            private final String[] args$1;
            private final Boolean stopAtNonOptions$1;
            private final DefaultParser parser$1;

            public final CommandLine apply() {
                return this.parser$1.parse(this.options$1, this.args$1, Predef$.MODULE$.Boolean2boolean(this.stopAtNonOptions$1));
            }
            {
                this.options$1 = options$1;
                this.args$1 = args$1;
                this.stopAtNonOptions$1 = stopAtNonOptions$1;
                this.parser$1 = parser$1;
            }
        });
        if (try_ instanceof Success) {
            CommandLine value;
            Success success = (Success)try_;
            CommandLine commandLine = value = (CommandLine)success.value();
            return commandLine;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    private FlinkRunOption$() {
        MODULE$ = this;
        this.HELP_OPTION = new Option("h", "help", false, "Show the help message for the CLI Frontend or the action.");
        this.JAR_OPTION = new Option("j", "jarfile", true, "Flink program JAR file.");
        this.CLASS_OPTION = new Option("c", "class", true, "Class with the program entry point (\"main()\" method). Only needed if the JAR file does not specify the class in its manifest.");
        this.CLASSPATH_OPTION = new Option("C", "classpath", true, "Adds a URL to each user code classloader  on all nodes in the cluster. The paths must specify a protocol (e.g. file://) and be accessible on all nodes (e.g. by means of a NFS share). You can use this option multiple times for specifying more than one URL. The protocol must be supported by the {@link java.net.URLClassLoader}.");
        this.PARALLELISM_OPTION = new Option("p", "parallelism", true, "The parallelism with which to run the program. Optional flag to override the default value specified in the configuration.");
        this.DETACHED_OPTION = new Option("d", "detached", false, "If present, runs the job in detached mode");
        this.SHUTDOWN_IF_ATTACHED_OPTION = new Option("sae", "shutdownOnAttachedExit", false, "If the job is submitted in attached mode, perform a best-effort cluster shutdown when the CLI is terminated abruptly, e.g., in response to a user interrupt, such as typing Ctrl + C.");
        this.YARN_DETACHED_OPTION = new Option("yd", "yarndetached", false, "If present, runs the job in detached mode (deprecated; use non-YARN specific option instead)");
        this.ARGS_OPTION = new Option("a", "arguments", true, "Program arguments. Arguments can also be added without -a, simply as trailing parameters.");
        this.ADDRESS_OPTION = new Option("m", "jobmanager", true, "Address of the JobManager to which to connect. Use this flag to connect to a different JobManager than the one specified in the configuration.");
        this.SAVEPOINT_PATH_OPTION = new Option("s", "fromSavepoint", true, "Path to a savepoint to restore the job from (for example hdfs:///flink/savepoint-1537).");
        this.SAVEPOINT_ALLOW_NON_RESTORED_OPTION = new Option("n", "allowNonRestoredState", false, "Allow to skip savepoint state that cannot be restored. You need to allow this if you removed an operator from your program that was part of the program when the savepoint was triggered.");
        this.SAVEPOINT_DISPOSE_OPTION = new Option("d", "dispose", true, "Path of savepoint to dispose.");
        this.RUNNING_OPTION = new Option("r", "running", false, "Show only running programs and their JobIDs");
        this.SCHEDULED_OPTION = new Option("s", "scheduled", false, "Show only scheduled programs and their JobIDs");
        this.ALL_OPTION = new Option("a", "all", false, "Show all programs and their JobIDs");
        this.ZOOKEEPER_NAMESPACE_OPTION = new Option("z", "zookeeperNamespace", true, "Namespace to create the Zookeeper sub-paths for high availability mode");
        this.CANCEL_WITH_SAVEPOINT_OPTION = new Option("s", "withSavepoint", true, "**DEPRECATION WARNING**: Cancelling a job with savepoint is deprecated. Use \"stop\" instead. \n Trigger savepoint and cancel job. The target directory is optional. If no directory is specified, the configured default directory ( state.savepoints.dir ) is used.");
        this.STOP_WITH_SAVEPOINT_PATH = new Option("p", "savepointPath", true, "Path to the savepoint (for example hdfs:///flink/savepoint-1537). If no directory is specified, the configured default will be used (\"state.savepoints.dir\").");
        this.STOP_AND_DRAIN = new Option("d", "drain", false, "Send MAX_WATERMARK before taking the savepoint and stopping the pipelne.");
        this.PY_OPTION = new Option("py", "python", true, "Python script with the program entry point. The dependent resources can be configured with the `--pyFiles` option.");
        this.PYFILES_OPTION = new Option("pyfs", "pyFiles", true, "Attach custom python files for job. These files will be added to the PYTHONPATH of both the local client and the remote python UDF worker. The standard python resource file suffixes such as .py/.egg/.zip or directory are all supported. Comma (',') could be used as the separator to specify multiple files (e.g.: --pyFiles file:///tmp/myresource.zip,hdfs:///$namenode_address/myresource2.zip).");
        this.PYMODULE_OPTION = new Option("pym", "pyModule", true, "Python module with the program entry point. This option must be used in conjunction with `--pyFiles`.");
        this.PYREQUIREMENTS_OPTION = new Option("pyreq", "pyRequirements", true, "Specify a requirements.txt file which defines the third-party dependencies. These dependencies will be installed and added to the PYTHONPATH of the python UDF worker. A directory which contains the installation packages of these dependencies could be specified optionally. Use '#' as the separator if the optional parameter exists (e.g.: --pyRequirements file:///tmp/requirements.txt#file:///tmp/cached_dir).");
        this.PYARCHIVE_OPTION = new Option("pyarch", "pyArchives", true, "Add python archive files for job. The archive files will be extracted to the working directory of python UDF worker. Currently only zip-format is supported. For each archive file, a target directory be specified. If the target directory name is specified, the archive file will be extracted to a name can directory with the specified name. Otherwise, the archive file will be extracted to a directory with the same name of the archive file. The files uploaded via this option are accessible via relative path. '#' could be used as the separator of the archive file path and the target directory name. Comma (',') could be used as the separator to specify multiple archive files. This option can be used to upload the virtual environment, the data files used in Python UDF (e.g.: --pyArchives file:///tmp/py37.zip,file:///tmp/data.zip#data --pyExecutable py37.zip/py37/bin/python). The data files could be accessed in Python UDF, e.g.: f = open('data/data.txt', 'r').");
        this.PYEXEC_OPTION = new Option("pyexec", "pyExecutable", true, "Specify the path of the python interpreter used to execute the python UDF worker (e.g.: --pyExecutable /usr/local/bin/python3). The python UDF worker depends on Python 3.5+, Apache Beam (version == 2.23.0), Pip (version >= 7.1.0) and SetupTools (version >= 37.0.0). Please ensure that the specified environment meets the above requirements.");
        this.DYNAMIC_PROPERTIES = Option.builder((String)"D").argName("property=value").numberOfArgs(2).valueSeparator('=').desc("Allows specifying multiple generic configuration options. The available options can be found at https://ci.apache.org/projects/flink/flink-docs-stable/ops/config.html").build();
        this.EXECUTOR_OPTION = new Option("e", "executor", true, "DEPRECATED: Please use the -t option instead which is also available with the \"Application Mode\".\nThe name of the executor to be used for executing the given job, which is equivalent to the \"execution.target\" config option.");
        this.TARGET_OPTION = new Option("t", "target", true, "The deployment target for the given application, which is equivalent to the \"execution.target\" config option. For the \"run\" action the currently available targets are: $getExecutorFactoryNames(). For the \"run-application\" action");
        this.HELP_OPTION().setRequired(false);
        this.JAR_OPTION().setRequired(false);
        this.JAR_OPTION().setArgName("jarfile");
        this.CLASS_OPTION().setRequired(false);
        this.CLASS_OPTION().setArgName("classname");
        this.CLASSPATH_OPTION().setRequired(false);
        this.CLASSPATH_OPTION().setArgName("url");
        this.PARALLELISM_OPTION().setRequired(false);
        this.PARALLELISM_OPTION().setArgName("parallelism");
        this.DETACHED_OPTION().setRequired(false);
        this.SHUTDOWN_IF_ATTACHED_OPTION().setRequired(false);
        this.YARN_DETACHED_OPTION().setRequired(false);
        this.ARGS_OPTION().setRequired(false);
        this.ARGS_OPTION().setArgName("programArgs");
        this.ARGS_OPTION().setArgs(-2);
        this.RUNNING_OPTION().setRequired(false);
        this.SCHEDULED_OPTION().setRequired(false);
        this.SAVEPOINT_PATH_OPTION().setRequired(false);
        this.SAVEPOINT_PATH_OPTION().setArgName("savepointPath");
        this.SAVEPOINT_ALLOW_NON_RESTORED_OPTION().setRequired(false);
        this.ZOOKEEPER_NAMESPACE_OPTION().setRequired(false);
        this.ZOOKEEPER_NAMESPACE_OPTION().setArgName("zookeeperNamespace");
        this.CANCEL_WITH_SAVEPOINT_OPTION().setRequired(false);
        this.CANCEL_WITH_SAVEPOINT_OPTION().setArgName("targetDirectory");
        this.CANCEL_WITH_SAVEPOINT_OPTION().setOptionalArg(true);
        this.STOP_WITH_SAVEPOINT_PATH().setRequired(false);
        this.STOP_WITH_SAVEPOINT_PATH().setArgName("savepointPath");
        this.STOP_WITH_SAVEPOINT_PATH().setOptionalArg(true);
        this.STOP_AND_DRAIN().setRequired(false);
        this.PY_OPTION().setRequired(false);
        this.PY_OPTION().setArgName("pythonFile");
        this.PYFILES_OPTION().setRequired(false);
        this.PYFILES_OPTION().setArgName("pythonFiles");
        this.PYMODULE_OPTION().setRequired(false);
        this.PYMODULE_OPTION().setArgName("pythonModule");
        this.PYREQUIREMENTS_OPTION().setRequired(false);
        this.PYARCHIVE_OPTION().setRequired(false);
        this.PYEXEC_OPTION().setRequired(false);
    }
}

