/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.vault.util.StandaloneManagerProvider;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeValidator;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.CndUtil;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.URLFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeValidatorFactory
implements ValidatorFactory {
    public static final String OPTION_CNDS = "cnds";
    public static final String OPTION_DEFAULT_NODE_TYPES = "defaultNodeType";
    @NotNull
    static final String DEFAULT_DEFAULT_NODE_TYPE = "nt:folder";
    public static final String OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES = "severityForUnknownNodetypes";
    @NotNull
    static final ValidationMessageSeverity DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE = ValidationMessageSeverity.WARN;
    public static final String OPTION_SEVERITY_FOR_DEFAULT_NODE_TYPE_VIOLATIONS = "severityForDefaultNodeTypeViolations";
    @NotNull
    static final ValidationMessageSeverity DEFAULT_SEVERITY_FOR_DEFAULT_NODE_TYPE_VIOLATIONS = ValidationMessageSeverity.WARN;
    public static final String OPTION_VALID_NAMESPACES = "validNameSpaces";
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeTypeValidatorFactory.class);

    @Override
    @Nullable
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        ValidationMessageSeverity severityForDefaultNodeTypeViolations;
        ValidationMessageSeverity severityForUnknownNodetypes;
        String cndUrls = settings.getOptions().get(OPTION_CNDS);
        if (StringUtils.isBlank((CharSequence)cndUrls)) {
            cndUrls = this.getClass().getClassLoader().getResource("default-nodetypes.cnd").toString();
            LOGGER.warn("Using default nodetypes, consider specifying the nodetypes from the repository you use!");
        }
        String defaultNodeType = settings.getOptions().containsKey(OPTION_DEFAULT_NODE_TYPES) ? settings.getOptions().get(OPTION_DEFAULT_NODE_TYPES) : DEFAULT_DEFAULT_NODE_TYPE;
        if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES)) {
            String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES);
            severityForUnknownNodetypes = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
        } else {
            severityForUnknownNodetypes = DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE;
        }
        if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_DEFAULT_NODE_TYPE_VIOLATIONS)) {
            String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_DEFAULT_NODE_TYPE_VIOLATIONS);
            severityForDefaultNodeTypeViolations = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
        } else {
            severityForDefaultNodeTypeViolations = DEFAULT_SEVERITY_FOR_DEFAULT_NODE_TYPE_VIOLATIONS;
        }
        Map<Object, Object> validNameSpaces = settings.getOptions().containsKey(OPTION_VALID_NAMESPACES) ? NodeTypeValidatorFactory.parseNamespaces(settings.getOptions().get(OPTION_VALID_NAMESPACES)) : Collections.emptyMap();
        try {
            StandaloneManagerProvider managerProvider = new StandaloneManagerProvider();
            URLFactory.processUrlStreams(CndUtil.resolveJarUrls(Arrays.asList(cndUrls.split(","))), t -> {
                try {
                    managerProvider.registerNodeTypes(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (RepositoryException | ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            });
            for (Map.Entry<Object, Object> entry : validNameSpaces.entrySet()) {
                managerProvider.registerNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            return new NodeTypeValidator(context.isIncremental(), context.getFilter(), managerProvider, managerProvider.getNameResolver().getQName(defaultNodeType), settings.getDefaultSeverity(), severityForUnknownNodetypes, severityForDefaultNodeTypeViolations);
        }
        catch (IOException | RepositoryException | ParseException e) {
            throw new IllegalArgumentException("Error loading default node type " + defaultNodeType, e);
        }
    }

    static Map<String, String> parseNamespaces(String optionValue) {
        String[] namespaces;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String namespace : namespaces = optionValue.split(",")) {
            String[] namespaceParts = namespace.split("=");
            if (namespaceParts.length != 2 || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{namespaceParts[0], namespaceParts[1]})) continue;
            result.put(namespaceParts[0].trim(), namespaceParts[1].trim());
        }
        return result;
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-nodetypes";
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

