/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HierarchyEntryImpl
implements HierarchyEntry {
    private static Logger log = LoggerFactory.getLogger(HierarchyEntryImpl.class);
    private long generation;
    private Reference<ItemState> target;
    protected Name name;
    protected NodeEntryImpl parent;
    protected final EntryFactory factory;

    HierarchyEntryImpl(NodeEntryImpl parent, Name name, EntryFactory factory) {
        this.parent = parent;
        this.name = name;
        this.factory = factory;
    }

    protected TransientItemStateFactory getItemStateFactory() {
        return this.factory.getItemStateFactory();
    }

    protected PathFactory getPathFactory() {
        return this.factory.getPathFactory();
    }

    protected IdFactory getIdFactory() {
        return this.factory.getIdFactory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemState resolve() throws ItemNotFoundException, RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            try {
                state = this.doResolve();
                if (this.internalGetItemState() != null) return state;
                this.setItemState(state);
                return state;
            }
            catch (ItemNotFoundException e) {
                this.remove();
                throw e;
            }
        } else {
            if (state.getStatus() != 0) return state;
            this.reload(false);
        }
        return state;
    }

    abstract ItemState doResolve() throws ItemNotFoundException, RepositoryException;

    abstract Path buildPath(boolean var1) throws RepositoryException;

    ItemState internalGetItemState() {
        ItemState state = null;
        if (this.target != null) {
            state = this.target.get();
        }
        return state;
    }

    protected EntryFactory.InvalidationStrategy getInvalidationStrategy() {
        return this.factory.getInvalidationStrategy();
    }

    protected void invalidateInternal(boolean recursive) {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            log.debug("Skip invalidation for unresolved HierarchyEntry " + this.name);
        } else {
            state.invalidate();
        }
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Path getPath() throws RepositoryException {
        return this.buildPath(false);
    }

    @Override
    public Path getWorkspacePath() throws RepositoryException {
        return this.buildPath(true);
    }

    @Override
    public NodeEntry getParent() {
        return this.parent;
    }

    @Override
    public int getStatus() {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return -1;
        }
        return state.getStatus();
    }

    @Override
    public boolean isAvailable() {
        return this.internalGetItemState() != null;
    }

    @Override
    public ItemState getItemState() throws ItemNotFoundException, RepositoryException {
        ItemState state = this.resolve();
        return state;
    }

    @Override
    public synchronized void setItemState(ItemState state) {
        ItemState currentState = this.internalGetItemState();
        if (state == null || state == currentState || this.denotesNode() != state.isNode()) {
            throw new IllegalArgumentException();
        }
        if (currentState == null) {
            this.target = new SoftReference<ItemState>(state);
        } else {
            int currentStatus = currentState.getStatus();
            boolean keepChanges = Status.isTransient(currentStatus) || Status.isStale(currentStatus);
            ItemState.MergeResult mergeResult = currentState.merge(state, keepChanges);
            if (currentStatus == 0) {
                currentState.setStatus(1);
            } else if (mergeResult.modified()) {
                currentState.setStatus(7);
            }
            mergeResult.dispose();
        }
    }

    @Override
    public void invalidate(boolean recursive) {
        this.getInvalidationStrategy().invalidate(this, recursive);
    }

    @Override
    public void calculateStatus() {
        this.getInvalidationStrategy().applyPending(this);
    }

    @Override
    public void revert() throws RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return;
        }
        int oldStatus = state.getStatus();
        switch (oldStatus) {
            case 2: 
            case 5: {
                state.revert();
                state.setStatus(1);
                break;
            }
            case 3: {
                state.revert();
                state.setStatus(1);
                break;
            }
            case 4: {
                state.setStatus(8);
                this.parent.internalRemoveChildEntry(this);
                break;
            }
            case 6: {
                this.remove();
                break;
            }
            default: {
                log.debug("State with status " + oldStatus + " cannot be reverted.");
            }
        }
    }

    @Override
    public void reload(boolean recursive) {
        int status = this.getStatus();
        if (status == -1) {
            return;
        }
        if (Status.isTransient(status) || Status.isStale(status) || Status.isTerminal(status)) {
            log.debug("Skip reload for item with status " + Status.getName(status) + ".");
            return;
        }
        try {
            TransientItemStateFactory isf = this.getItemStateFactory();
            if (this.denotesNode()) {
                NodeEntry ne = (NodeEntry)((Object)this);
                isf.createNodeState(ne.getWorkspaceId(), ne);
            } else {
                PropertyEntry pe = (PropertyEntry)((Object)this);
                isf.createPropertyState(pe.getWorkspaceId(), pe);
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("Item '" + this.getName() + "' cannot be found on the persistent layer -> remove.");
            this.remove();
        }
        catch (RepositoryException e) {
            log.error("Exception while reloading item: " + (Object)((Object)e));
        }
    }

    @Override
    public void transientRemove() throws InvalidItemStateException, RepositoryException {
        ItemState state = this.internalGetItemState();
        if (state == null) {
            return;
        }
        if (state.getStatus() == 0) {
            this.reload(false);
        }
        switch (state.getStatus()) {
            case 4: {
                state.setStatus(8);
                this.parent.internalRemoveChildEntry(this);
                break;
            }
            case 1: 
            case 2: {
                state.setStatus(3);
                break;
            }
            case 6: 
            case 8: {
                throw new InvalidItemStateException("Item has already been removed by someone else. Status = " + Status.getName(state.getStatus()));
            }
            default: {
                throw new RepositoryException("Cannot transiently remove an ItemState with status " + Status.getName(state.getStatus()));
            }
        }
    }

    @Override
    public void remove() {
        this.internalRemove(false);
    }

    @Override
    public long getGeneration() {
        this.calculateStatus();
        return this.generation;
    }

    void internalRemove(boolean staleParent) {
        ItemState state = this.internalGetItemState();
        int status = this.getStatus();
        if (state != null) {
            if (status == 2) {
                state.setStatus(6);
            } else if (status != 4 || !staleParent) {
                state.setStatus(8);
                if (!staleParent) {
                    this.parent.internalRemoveChildEntry(this);
                }
            }
        } else if (!staleParent && this.parent != null) {
            this.parent.internalRemoveChildEntry(this);
        }
    }

    static class LazyInvalidation
    implements EntryFactory.InvalidationStrategy {
        private static long INVALIDATION_PENDING = -1L;
        private long currentGeneration;
        private int nextGeneration;
        private boolean invalidating;

        LazyInvalidation() {
        }

        @Override
        public void invalidate(HierarchyEntry entry, boolean recursive) {
            HierarchyEntryImpl he = (HierarchyEntryImpl)entry;
            if (recursive) {
                he.generation = LazyInvalidation.INVALIDATION_PENDING;
                if (!this.invalidating) {
                    this.nextGeneration = 1;
                }
            } else {
                if (!this.invalidating) {
                    this.nextGeneration = 1;
                }
                he.invalidateInternal(false);
            }
        }

        @Override
        public void applyPending(HierarchyEntry entry) {
            if (!this.invalidating) {
                this.invalidating = true;
                this.currentGeneration += (long)this.nextGeneration;
                this.nextGeneration = 0;
                try {
                    HierarchyEntryImpl he = (HierarchyEntryImpl)entry;
                    if (he.generation == INVALIDATION_PENDING) {
                        he.invalidateInternal(true);
                        he.generation = this.currentGeneration;
                    } else if (he.generation < this.currentGeneration) {
                        this.resolvePendingInvalidation(he);
                    }
                }
                finally {
                    this.invalidating = false;
                }
            }
        }

        private void resolvePendingInvalidation(HierarchyEntryImpl entry) {
            if (entry != null) {
                if (entry.generation != INVALIDATION_PENDING) {
                    this.resolvePendingInvalidation(entry.parent);
                }
                if (entry.generation == INVALIDATION_PENDING) {
                    entry.invalidateInternal(true);
                }
                entry.generation = this.currentGeneration;
            }
        }
    }
}

