/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.jetbrains.annotations.NotNull;

class WorkspaceFilterBuilder {
    private final WorkspaceFilter baseFilter;
    private final Set<String> filteredPaths;
    private final Set<String> cpPaths;
    private final Set<String> extractedPaths;

    WorkspaceFilterBuilder(@NotNull WorkspaceFilter baseFilter, @NotNull Set<String> filteredRepositoryPaths, @NotNull Set<String> convertedRepositoryPaths, @NotNull Set<String> extractedRepositoryPaths) {
        this.baseFilter = baseFilter;
        this.filteredPaths = filteredRepositoryPaths;
        this.cpPaths = convertedRepositoryPaths;
        this.extractedPaths = extractedRepositoryPaths;
    }

    @NotNull
    WorkspaceFilter build() throws IOException {
        try {
            DefaultWorkspaceFilter dwf = new DefaultWorkspaceFilter();
            Map<String, PathFilterSet> propFilters = WorkspaceFilterBuilder.extractPropertyFilters(this.baseFilter);
            for (PathFilterSet pfs : this.baseFilter.getFilterSets()) {
                if (!this.coversConvertedPath(pfs) && this.coversFilteredPath(pfs)) continue;
                this.processPathFilterSet(dwf, pfs, propFilters);
            }
            return dwf;
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    static Map<String, PathFilterSet> extractPropertyFilters(@NotNull WorkspaceFilter base) {
        LinkedHashMap<String, PathFilterSet> propFilters = new LinkedHashMap<String, PathFilterSet>();
        base.getPropertyFilterSets().forEach(pathFilterSet -> propFilters.put(pathFilterSet.getRoot(), (PathFilterSet)pathFilterSet));
        return propFilters;
    }

    private boolean coversFilteredPath(@NotNull PathFilterSet pfs) {
        return this.filteredPaths.stream().anyMatch(arg_0 -> ((PathFilterSet)pfs).covers(arg_0));
    }

    private boolean coversConvertedPath(@NotNull PathFilterSet pfs) {
        return this.cpPaths.stream().anyMatch(arg_0 -> ((PathFilterSet)pfs).covers(arg_0)) || this.extractedPaths.stream().anyMatch(path -> path.equals(pfs.getRoot()) || Text.isSibling((String)path, (String)pfs.getRoot()));
    }

    private void processPathFilterSet(@NotNull DefaultWorkspaceFilter newFilter, @NotNull PathFilterSet pfs, @NotNull Map<String, PathFilterSet> propFilters) throws ConfigurationException {
        PathFilterSet nodeFilterSet = WorkspaceFilterBuilder.copyPathFilterSet(pfs, this.filteredPaths);
        PathFilterSet propPfs = propFilters.remove(pfs.getRoot());
        if (propPfs != null) {
            PathFilterSet propFilterSet = WorkspaceFilterBuilder.copyPathFilterSet(propPfs, Collections.emptySet());
            newFilter.add(nodeFilterSet, propFilterSet);
        } else {
            newFilter.add(nodeFilterSet);
        }
    }

    @NotNull
    private static PathFilterSet copyPathFilterSet(@NotNull PathFilterSet pfs, @NotNull Set<String> filteredPaths) throws ConfigurationException {
        PathFilterSet filterSet = new PathFilterSet(pfs.getRoot());
        filterSet.setType(pfs.getType());
        filterSet.setImportMode(pfs.getImportMode());
        for (FilterSet.Entry entry : pfs.getEntries()) {
            if (entry.isInclude()) {
                filterSet.addInclude((Filter)((PathFilter)entry.getFilter()));
                continue;
            }
            filterSet.addExclude((Filter)((PathFilter)entry.getFilter()));
        }
        for (String path : filteredPaths) {
            if (!pfs.covers(path)) continue;
            filterSet.addExclude((Filter)new DefaultPathFilter(path));
        }
        return filterSet;
    }
}

