/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceImport<T>
implements Import<T>,
Comparable<Import<T>> {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceImport.class.getName());
    static final int MODIFIED = 0;
    static final int UNREGISTERING = 1;
    private static final int INVALID = -1;
    private static final int DORMANT = 0;
    private static final int ACTIVE = 1;
    private volatile T instance;
    private final AtomicInteger count = new AtomicInteger();
    private volatile int state;
    private int generation;
    private final List<Export<?>> watchers = new ArrayList(2);
    private static volatile int cacheGeneration;

    protected AbstractServiceImport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        this.count.getAndIncrement();
        if (0 == this.state) {
            AbstractServiceImport abstractServiceImport = this;
            synchronized (abstractServiceImport) {
                if (0 == this.state) {
                    try {
                        this.instance = this.acquireService();
                    }
                    catch (RuntimeException re) {
                        throw new ServiceUnavailableException(re);
                    }
                    finally {
                        this.state = 1;
                    }
                }
            }
        }
        return this.instance;
    }

    @Override
    public final void unget() {
        this.generation = cacheGeneration;
        this.count.decrementAndGet();
    }

    @Override
    public final boolean available() {
        return -1 != this.state;
    }

    void addWatcher(Export<?> export) {
        this.watchers.add(export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate() {
        this.notifyWatchers(1);
        this.watchers.clear();
        AbstractServiceImport abstractServiceImport = this;
        synchronized (abstractServiceImport) {
            this.instance = null;
            this.state = -1;
        }
    }

    public static final void setCacheGeneration(int newGeneration) {
        cacheGeneration = newGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(int targetGeneration) {
        if (targetGeneration == this.generation && 1 == this.state && 0 == this.count.get()) {
            AbstractServiceImport abstractServiceImport = this;
            synchronized (abstractServiceImport) {
                if (-1 == this.state) {
                    return;
                }
                this.state = 0;
                if (this.count.get() > 0) {
                    this.state = 1;
                } else {
                    try {
                        this.releaseService(this.instance);
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        this.instance = null;
                    }
                }
            }
        }
    }

    void notifyWatchers(int eventType) {
        for (Export<?> export : this.watchers) {
            try {
                switch (eventType) {
                    case 0: {
                        export.attributes(this.attributes());
                        break;
                    }
                    case 1: {
                        export.unput();
                        break;
                    }
                }
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.WARNING, "Exception in service watcher", re);
            }
        }
    }

    protected abstract T acquireService();

    protected abstract boolean hasRankingChanged();

    protected abstract void releaseService(T var1);
}

