/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jetty.v9.client;

import java.nio.ByteBuffer;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.Callback;

public class ResponseListenerWrapper
implements Response.Listener {
    private final Response.Listener listener;
    private final ContextSnapshot context;

    public ResponseListenerWrapper(Response.Listener listener, ContextSnapshot context) {
        this.listener = listener;
        this.context = context;
    }

    public void onComplete(Result result) {
        AbstractSpan span = ContextManager.createLocalSpan((String)"JettyClient9.x/CompleteListener/onComplete");
        span.setComponent((Component)ComponentsDefine.JETTY_CLIENT);
        SpanLayer.asHttp((AbstractSpan)span);
        if (this.context != null) {
            ContextManager.continued((ContextSnapshot)this.context);
        }
        if (this.listener != null) {
            this.listener.onComplete(result);
        }
        ContextManager.stopSpan();
    }

    public void onHeaders(Response response) {
        this.listener.onHeaders(response);
    }

    public void onContent(Response response, ByteBuffer content, Callback callback) {
        this.listener.onContent(response, content, callback);
    }

    public void onContent(Response response, ByteBuffer content) {
        this.listener.onContent(response, content);
    }

    public void onBegin(Response response) {
        this.listener.onBegin(response);
    }

    public boolean onHeader(Response response, HttpField field) {
        return this.listener.onHeader(response, field);
    }

    public void onSuccess(Response response) {
        this.listener.onSuccess(response);
    }

    public void onFailure(Response response, Throwable failure) {
        this.listener.onFailure(response, failure);
    }
}

