/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.LROp;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;

public class CompareOp {
    public static ExpressionResult doCompareOP(ExpressionResult left, ExpressionResult right, int opType) throws IllegalExpressionException {
        try {
            return LROp.doLROp(left, right, opType, CompareOp::scalarCompareOp);
        }
        catch (IllegalExpressionException e) {
            throw new IllegalExpressionException("Unsupported compare operation: " + e.getMessage());
        }
    }

    private static int scalarCompareOp(double leftValue, double rightValue, int opType) {
        int comparedResult = 0;
        switch (opType) {
            case 17: {
                comparedResult = CompareOp.boolToInt(leftValue == rightValue);
                break;
            }
            case 18: {
                comparedResult = CompareOp.boolToInt(leftValue != rightValue);
                break;
            }
            case 22: {
                comparedResult = CompareOp.boolToInt(leftValue > rightValue);
                break;
            }
            case 20: {
                comparedResult = CompareOp.boolToInt(leftValue < rightValue);
                break;
            }
            case 21: {
                comparedResult = CompareOp.boolToInt(leftValue >= rightValue);
                break;
            }
            case 19: {
                comparedResult = CompareOp.boolToInt(leftValue <= rightValue);
            }
        }
        return comparedResult;
    }

    private static int boolToInt(boolean v) {
        return v ? 1 : 0;
    }
}

