/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.mesh;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.servicemesh.v3.MeshProbeDownstream;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetricServiceGrpc;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGRPCHandler
extends ServiceMeshMetricServiceGrpc.ServiceMeshMetricServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeshGRPCHandler.class);

    public MeshGRPCHandler(ModuleManager moduleManager) {
    }

    public StreamObserver<ServiceMeshMetrics> collect(final StreamObserver<MeshProbeDownstream> responseObserver) {
        return new StreamObserver<ServiceMeshMetrics>(){

            public void onNext(ServiceMeshMetrics metrics) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received mesh metrics: {}", (Object)metrics);
                }
                TelemetryDataDispatcher.process(metrics);
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                LOGGER.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)MeshProbeDownstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

