/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.FallthroughException;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import java.lang.reflect.ParameterizedType;

final class CompositeRequestConverterFunction
implements RequestConverterFunction {
    private final ImmutableList<RequestConverterFunction> functions;

    CompositeRequestConverterFunction(ImmutableList<RequestConverterFunction> functions) {
        this.functions = functions;
    }

    @Override
    @Nullable
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        for (RequestConverterFunction function : this.functions) {
            try {
                return function.convertRequest(ctx, request, expectedResultType, expectedParameterizedResultType);
            }
            catch (FallthroughException fallthroughException) {
            }
            catch (Exception e) {
                throw new IllegalStateException("Request converter " + function.getClass().getName() + " failed to convert an " + request + " to a " + expectedResultType, e);
            }
        }
        return RequestConverterFunction.fallthrough();
    }
}

