/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.websocket;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.websocket.ByteBufWebSocketFrame;
import com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketFrameType;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class CloseByteBufWebSocketFrame
extends ByteBufWebSocketFrame
implements CloseWebSocketFrame {
    private final WebSocketCloseStatus status;
    @Nullable
    private final String reasonPhrase;

    CloseByteBufWebSocketFrame(byte[] data) {
        this(Unpooled.wrappedBuffer(data), false);
    }

    CloseByteBufWebSocketFrame(ByteBuf data, boolean pooled) {
        this(data, pooled, CloseByteBufWebSocketFrame.status(data), CloseByteBufWebSocketFrame.reasonPhrase(data));
    }

    CloseByteBufWebSocketFrame(WebSocketCloseStatus status, String reasonPhrase) {
        this(CloseByteBufWebSocketFrame.createByteBuf(CloseByteBufWebSocketFrame.validateStatusCode(status.code()), Objects.requireNonNull(reasonPhrase, "reasonPhrase")), false, status, reasonPhrase);
    }

    private CloseByteBufWebSocketFrame(ByteBuf data, boolean pooled, WebSocketCloseStatus status, @Nullable String reasonPhrase) {
        super(data, pooled, WebSocketFrameType.CLOSE, true);
        this.status = status;
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public WebSocketCloseStatus status() {
        return this.status;
    }

    private static WebSocketCloseStatus status(ByteBuf data) {
        if (data.capacity() == 0) {
            data.release();
            throw new IllegalArgumentException("data must have a close status.");
        }
        int index = data.readerIndex();
        short statusCode = data.readShort();
        data.readerIndex(index);
        try {
            CloseByteBufWebSocketFrame.validateStatusCode(statusCode);
        }
        catch (Throwable t) {
            data.release();
            throw t;
        }
        return WebSocketCloseStatus.valueOf(statusCode);
    }

    private static int validateStatusCode(int statusCode) {
        if (WebSocketCloseStatus.isValidStatusCode(statusCode)) {
            return statusCode;
        }
        throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC 6455. code: " + statusCode);
    }

    @Override
    @Nullable
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    @Nullable
    private static String reasonPhrase(ByteBuf data) {
        if (data.capacity() <= 2) {
            return null;
        }
        int index = data.readerIndex();
        if (index + 2 >= data.writerIndex()) {
            return null;
        }
        data.readerIndex(index + 2);
        String reasonPhrase = data.toString(StandardCharsets.UTF_8);
        data.readerIndex(index);
        return reasonPhrase;
    }

    private static ByteBuf createByteBuf(int statusCode, String reasonPhrase) {
        ByteBuf byteBuf = Unpooled.buffer(2 + reasonPhrase.length());
        byteBuf.writeShort(statusCode);
        if (!reasonPhrase.isEmpty()) {
            byteBuf.writeCharSequence(reasonPhrase, StandardCharsets.UTF_8);
        }
        byteBuf.readerIndex(0);
        return byteBuf;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Objects.hash(this.status, this.reasonPhrase);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CloseByteBufWebSocketFrame)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CloseByteBufWebSocketFrame that = (CloseByteBufWebSocketFrame)obj;
        return this.status.equals(that.status()) && Objects.equals(this.reasonPhrase, that.reasonPhrase()) && super.equals(obj);
    }

    @Override
    void addToString(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("status", this.status).add("reasonPhrase", this.reasonPhrase);
    }
}

