/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.StreamTimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamTimeoutMode;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class TimeoutStreamMessage<T>
implements StreamMessage<T> {
    private final StreamMessage<? extends T> delegate;
    private final Duration timeoutDuration;
    private final StreamTimeoutMode timeoutMode;

    TimeoutStreamMessage(StreamMessage<? extends T> delegate, Duration timeoutDuration, StreamTimeoutMode timeoutMode) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.timeoutDuration = Objects.requireNonNull(timeoutDuration, "timeoutDuration");
        this.timeoutMode = Objects.requireNonNull(timeoutMode, "timeoutMode");
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public long demand() {
        return this.delegate.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        this.delegate.subscribe(new TimeoutSubscriber<T>(subscriber, executor, this.timeoutDuration, this.timeoutMode), executor, options);
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    @Override
    public void abort(Throwable cause) {
        this.delegate.abort(cause);
    }

    static final class TimeoutSubscriber<T>
    implements Runnable,
    Subscriber<T>,
    Subscription {
        private static final String TIMEOUT_MESSAGE = "Stream timed out after %d ms (timeout mode: %s)";
        private final Subscriber<? super T> delegate;
        private final EventExecutor executor;
        private final StreamTimeoutMode timeoutMode;
        private final Duration timeoutDuration;
        private final long timeoutNanos;
        @Nullable
        private ScheduledFuture<?> timeoutFuture;
        @Nullable
        private Subscription subscription;
        private long lastEventTimeNanos;
        private boolean completed;
        private volatile boolean canceled;

        TimeoutSubscriber(Subscriber<? super T> delegate, EventExecutor executor, Duration timeoutDuration, StreamTimeoutMode timeoutMode) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.executor = Objects.requireNonNull(executor, "executor");
            this.timeoutDuration = Objects.requireNonNull(timeoutDuration, "timeoutDuration");
            this.timeoutNanos = timeoutDuration.toNanos();
            this.timeoutMode = Objects.requireNonNull(timeoutMode, "timeoutMode");
        }

        private ScheduledFuture<?> scheduleTimeout(long delay) {
            return this.executor.schedule(this, delay, TimeUnit.NANOSECONDS);
        }

        void cancelSchedule() {
            if (this.timeoutFuture != null && !this.timeoutFuture.isCancelled()) {
                this.timeoutFuture.cancel(false);
            }
        }

        @Override
        public void run() {
            long currentTimeNanos;
            long elapsedNanos;
            if (this.timeoutMode == StreamTimeoutMode.UNTIL_NEXT && (elapsedNanos = (currentTimeNanos = System.nanoTime()) - this.lastEventTimeNanos) < this.timeoutNanos) {
                long delayNanos = this.timeoutNanos - elapsedNanos;
                this.timeoutFuture = this.scheduleTimeout(delayNanos);
                return;
            }
            this.completed = true;
            this.delegate.onError(new StreamTimeoutException(String.format(TIMEOUT_MESSAGE, new Object[]{this.timeoutDuration.toMillis(), this.timeoutMode})));
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.subscription = s;
            this.delegate.onSubscribe(this);
            if (this.completed || this.canceled) {
                return;
            }
            this.lastEventTimeNanos = System.nanoTime();
            this.timeoutFuture = this.scheduleTimeout(this.timeoutNanos);
        }

        @Override
        public void onNext(T t) {
            if (this.completed || this.canceled) {
                PooledObjects.close(t);
                return;
            }
            switch (this.timeoutMode) {
                case UNTIL_NEXT: {
                    this.lastEventTimeNanos = System.nanoTime();
                    break;
                }
                case UNTIL_FIRST: {
                    this.cancelSchedule();
                    this.timeoutFuture = null;
                    break;
                }
            }
            this.delegate.onNext(t);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.cancelSchedule();
            this.delegate.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.cancelSchedule();
            this.delegate.onComplete();
        }

        @Override
        public void request(long l) {
            assert (this.subscription != null);
            this.subscription.request(l);
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.cancelSchedule();
            assert (this.subscription != null);
            this.subscription.cancel();
        }
    }
}

