/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.loadbalancer;

import com.linecorp.armeria.common.loadbalancer.WeightTransition;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;

final class LinearWeightTransition<T>
implements WeightTransition<T> {
    static final LinearWeightTransition<?> INSTANCE = new LinearWeightTransition();

    LinearWeightTransition() {
    }

    @Override
    public int compute(T candidate, int weight, int currentStep, int totalSteps) {
        int currentWeight = Ints.saturatedCast((long)weight * (long)currentStep / (long)totalSteps);
        if (weight > 0 && currentWeight == 0) {
            return 1;
        }
        return currentWeight;
    }

    public String toString() {
        return "WeightTransition.linear()";
    }
}

