/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@ScopeDeclaration(id=59, name="TCPServiceRelation", catalog="SERVICE_RELATION")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class TCPServiceRelation
extends Source {
    private String entityId;
    private String sourceServiceId;
    @ScopeDefaultColumn.DefinedByField(columnName="source_name", requireDynamicActive=true)
    private String sourceServiceName;
    private String sourceServiceInstanceName;
    private Layer sourceLayer;
    private String destServiceId;
    @ScopeDefaultColumn.DefinedByField(columnName="dest_name", requireDynamicActive=true)
    private String destServiceName;
    private Layer destLayer;
    private String destServiceInstanceName;
    private int componentId;
    private DetectPoint detectPoint;
    private String tlsMode;
    private SideCar sideCar = new SideCar();
    private long receivedBytes;
    private long sentBytes;

    @Override
    public int scope() {
        return 59;
    }

    @Override
    public String getEntityId() {
        if (StringUtil.isEmpty((String)this.entityId)) {
            this.entityId = IDManager.ServiceID.buildRelationId(new IDManager.ServiceID.ServiceRelationDefine(this.sourceServiceId, this.destServiceId));
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.sourceServiceId = IDManager.ServiceID.buildId(this.sourceServiceName, this.sourceLayer.isNormal());
        this.destServiceId = IDManager.ServiceID.buildId(this.destServiceName, this.destLayer.isNormal());
    }

    @Generated
    public String getSourceServiceId() {
        return this.sourceServiceId;
    }

    @Generated
    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    @Generated
    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    @Generated
    public String getSourceServiceInstanceName() {
        return this.sourceServiceInstanceName;
    }

    @Generated
    public void setSourceServiceInstanceName(String sourceServiceInstanceName) {
        this.sourceServiceInstanceName = sourceServiceInstanceName;
    }

    @Generated
    public Layer getSourceLayer() {
        return this.sourceLayer;
    }

    @Generated
    public void setSourceLayer(Layer sourceLayer) {
        this.sourceLayer = sourceLayer;
    }

    @Generated
    public String getDestServiceId() {
        return this.destServiceId;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    @Generated
    public Layer getDestLayer() {
        return this.destLayer;
    }

    @Generated
    public void setDestLayer(Layer destLayer) {
        this.destLayer = destLayer;
    }

    @Generated
    public String getDestServiceInstanceName() {
        return this.destServiceInstanceName;
    }

    @Generated
    public void setDestServiceInstanceName(String destServiceInstanceName) {
        this.destServiceInstanceName = destServiceInstanceName;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public String getTlsMode() {
        return this.tlsMode;
    }

    @Generated
    public void setTlsMode(String tlsMode) {
        this.tlsMode = tlsMode;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Generated
    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    @Generated
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Generated
    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }
}

