/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DispatcherDetectorListener;
import org.apache.skywalking.oap.server.core.analysis.DispatcherManager;
import org.apache.skywalking.oap.server.core.analysis.SourceDecoratorManager;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;

public class SourceReceiverImpl
implements SourceReceiver {
    private final DispatcherManager dispatcherManager = new DispatcherManager();
    private final SourceDecoratorManager sourceDecoratorManager = new SourceDecoratorManager();

    @Override
    public void receive(ISource source) {
        this.dispatcherManager.forward(source);
    }

    @Override
    public DispatcherDetectorListener getDispatcherDetectorListener() {
        return this.getDispatcherManager();
    }

    public void scan() throws IOException, InstantiationException, IllegalAccessException {
        ClassPath classpath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class aClass = classInfo.load();
            this.sourceDecoratorManager.addIfAsSourceDecorator(aClass);
            this.dispatcherManager.addIfAsSourceDispatcher(aClass);
        }
    }

    @Generated
    public DispatcherManager getDispatcherManager() {
        return this.dispatcherManager;
    }

    @Generated
    public SourceDecoratorManager getSourceDecoratorManager() {
        return this.sourceDecoratorManager;
    }
}

