/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type;

public class Bucket {
    public static final String INFINITE_NEGATIVE = "infinite-";
    public static final String INFINITE_POSITIVE = "infinite+";
    private String min = "0";
    private String max = "0";

    public Bucket() {
    }

    public Bucket(int min, int max) {
        this.setMin(min);
        this.setMax(max);
    }

    public Bucket setMin(int min) {
        this.min = String.valueOf(min);
        return this;
    }

    public Bucket setMax(int max) {
        this.max = String.valueOf(max);
        return this;
    }

    public Bucket infiniteMin() {
        this.min = INFINITE_NEGATIVE;
        return this;
    }

    public Bucket infiniteMax() {
        this.max = INFINITE_POSITIVE;
        return this;
    }

    public boolean isInfiniteMin() {
        return INFINITE_NEGATIVE.equals(this.min);
    }

    public boolean isInfiniteMax() {
        return INFINITE_POSITIVE.equals(this.max);
    }

    public int duration() {
        if (this.isInfiniteMin()) {
            return Integer.MIN_VALUE;
        }
        if (this.isInfiniteMax()) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.max) - Integer.parseInt(this.min);
    }
}

