/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfilerTaskCache
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProfilerTaskCache.class);
    private final Cache<String, AsyncProfilerTask> serviceId2taskCache;
    private final ModuleManager moduleManager;
    private IAsyncProfilerTaskQueryDAO taskQueryDAO;

    public AsyncProfilerTaskCache(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        long initialSize = moduleConfig.getMaxSizeOfProfileTask() / 10L;
        int initialCapacitySize = (int)(initialSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : initialSize);
        this.serviceId2taskCache = CacheBuilder.newBuilder().initialCapacity(initialCapacitySize).maximumSize(moduleConfig.getMaxSizeOfProfileTask()).expireAfterWrite(Duration.ofMinutes(1L)).build();
    }

    private IAsyncProfilerTaskQueryDAO getTaskQueryDAO() {
        if (Objects.isNull(this.taskQueryDAO)) {
            this.taskQueryDAO = (IAsyncProfilerTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IAsyncProfilerTaskQueryDAO.class);
        }
        return this.taskQueryDAO;
    }

    public AsyncProfilerTask getAsyncProfilerTask(String serviceId) {
        return (AsyncProfilerTask)this.serviceId2taskCache.getIfPresent((Object)serviceId);
    }

    public void saveTask(String serviceId, AsyncProfilerTask task) {
        if (task == null) {
            return;
        }
        this.serviceId2taskCache.put((Object)serviceId, (Object)task);
    }

    public long getCacheStartTimeBucket() {
        return TimeBucket.getRecordTimeBucket(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L));
    }

    public long getCacheEndTimeBucket() {
        return TimeBucket.getRecordTimeBucket(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L));
    }
}

