/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.annotation;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;
import org.apache.skywalking.oap.server.core.storage.StorageException;

public class AnnotationScan {
    private final List<AnnotationListenerCache> listeners = new LinkedList<AnnotationListenerCache>();

    public void registerListener(AnnotationListener listener) {
        this.listeners.add(new AnnotationListenerCache(listener));
    }

    public void scan() throws IOException, StorageException {
        ClassPath classpath = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class aClass = classInfo.load();
            for (AnnotationListenerCache listener : this.listeners) {
                if (!aClass.isAnnotationPresent(listener.annotation())) continue;
                listener.addMatch(aClass);
            }
        }
        for (AnnotationListenerCache listener : this.listeners) {
            listener.complete();
        }
    }

    private class AnnotationListenerCache {
        private AnnotationListener listener;
        private List<Class<?>> matchedClass;

        private AnnotationListenerCache(AnnotationListener listener) {
            this.listener = listener;
            this.matchedClass = new LinkedList();
        }

        private Class<? extends Annotation> annotation() {
            return this.listener.annotation();
        }

        private void addMatch(Class aClass) {
            this.matchedClass.add(aClass);
        }

        private void complete() throws StorageException {
            this.matchedClass.sort(Comparator.comparing(Class::getName));
            for (Class<?> aClass : this.matchedClass) {
                this.listener.notify(aClass);
            }
        }
    }
}

