/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.tls;

import com.alibaba.nacos.common.utils.InternetAddressUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelfHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfHostnameVerifier.class);
    private final HostnameVerifier hv;
    private static final ConcurrentHashMap<String, Boolean> HOSTS = new ConcurrentHashMap();
    private static final String[] LOCALHOST_HOSTNAME = new String[]{"localhost", InternetAddressUtil.localHostIP()};

    public SelfHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        if (LOCALHOST_HOSTNAME[0].equalsIgnoreCase(hostname) || LOCALHOST_HOSTNAME[1].equals(hostname)) {
            return true;
        }
        if (SelfHostnameVerifier.isIP(hostname)) {
            return true;
        }
        return this.hv.verify(hostname, session);
    }

    private static boolean isIP(String host) {
        if (host == null || host.isEmpty()) {
            LOGGER.warn("host is empty, isIP = false");
            return false;
        }
        Boolean cacheHostVerify = HOSTS.get(host);
        if (cacheHostVerify != null) {
            return cacheHostVerify;
        }
        boolean isIp = InternetAddressUtil.isIP(host);
        HOSTS.putIfAbsent(host, isIp);
        return isIp;
    }
}

