/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class UUIDGenerator
implements Generator<Object, String> {
    private final int changingFrequency;
    private final AtomicInteger counter;
    private final AtomicReference<String> last = new AtomicReference<String>(UUID.randomUUID().toString());

    public UUIDGenerator(Builder builder) {
        Preconditions.checkArgument((builder.changingFrequency > 0 ? 1 : 0) != 0, (Object)"changingFrequency must be greater than 0");
        this.changingFrequency = builder.changingFrequency;
        this.counter = new AtomicInteger();
        this.reset();
    }

    @Override
    public String next(Object ignored) {
        if (this.counter.incrementAndGet() < this.changingFrequency) {
            return this.last.get();
        }
        this.reset();
        return this.last.getAndSet(UUID.randomUUID().toString());
    }

    public String toString() {
        return String.valueOf(this.next((Object)null));
    }

    @Override
    public void reset() {
        this.counter.set(0);
    }

    public static class Builder {
        private int changingFrequency = 1;

        public UUIDGenerator build() {
            return new UUIDGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public int getChangingFrequency() {
            return this.changingFrequency;
        }

        @Generated
        public void setChangingFrequency(int changingFrequency) {
            this.changingFrequency = changingFrequency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getChangingFrequency() == other.getChangingFrequency();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getChangingFrequency();
            return result;
        }

        @Generated
        public String toString() {
            return "UUIDGenerator.Builder(changingFrequency=" + this.getChangingFrequency() + ")";
        }
    }
}

