/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider.kafka.trace;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import lombok.Generated;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.exporter.TraceExportService;
import org.apache.skywalking.oap.server.exporter.provider.ExporterSetting;
import org.apache.skywalking.oap.server.exporter.provider.kafka.KafkaExportProducer;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTraceExporter
extends KafkaExportProducer
implements TraceExportService,
IConsumer<SegmentRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaTraceExporter.class);
    private DataCarrier<SegmentRecord> exportBuffer;
    private CounterMetrics successCounter;
    private CounterMetrics errorCounter;
    private final ModuleManager moduleManager;

    public KafkaTraceExporter(ModuleManager manager, ExporterSetting setting) {
        super(setting);
        this.moduleManager = manager;
    }

    public void start() {
        super.getProducer();
        this.exportBuffer = new DataCarrier("KafkaTraceExporter", "KafkaTraceExporter", this.setting.getBufferChannelNum(), this.setting.getBufferChannelSize(), BufferStrategy.IF_POSSIBLE);
        this.exportBuffer.consume((IConsumer)this, 1, 200L);
        MetricsCreator metricsCreator = (MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.successCounter = metricsCreator.createCounter("kafka_exporter_trace_success_count", "The success number of traces exported by kafka exporter.", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
        this.errorCounter = metricsCreator.createCounter("kafka_exporter_trace_error_count", "The error number of traces exported by kafka exporter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    public void export(SegmentRecord segmentRecord) {
        if (segmentRecord != null) {
            this.exportBuffer.produce((Object)segmentRecord);
        }
    }

    public boolean isEnabled() {
        return this.setting.isEnableKafkaTrace();
    }

    public void consume(List<SegmentRecord> data) {
        for (SegmentRecord segmentRecord : data) {
            if (segmentRecord == null) continue;
            try {
                SegmentObject segmentObject = SegmentObject.parseFrom((byte[])segmentRecord.getDataBinary());
                if (this.setting.isExportErrorStatusTraceOnly() && !this.isError(segmentObject)) continue;
                ProducerRecord record = new ProducerRecord(this.setting.getKafkaTopicTrace(), (Object)segmentObject.getTraceSegmentId(), (Object)Bytes.wrap((byte[])segmentObject.toByteArray()));
                super.getProducer().send(record, (metadata, ex) -> {
                    if (ex != null) {
                        this.errorCounter.inc();
                        log.error("Failed to export Trace.", (Throwable)ex);
                    } else {
                        this.successCounter.inc();
                    }
                });
            }
            catch (InvalidProtocolBufferException e) {
                throw new UnexpectedException("Failed to parse SegmentObject from SegmentRecord, id: " + segmentRecord.getSegmentId() + ".", (Exception)((Object)e));
            }
        }
    }

    private boolean isError(SegmentObject segmentObject) {
        for (SpanObject spanObject : segmentObject.getSpansList()) {
            if (!spanObject.getIsError()) continue;
            return true;
        }
        return false;
    }

    public void onError(List<SegmentRecord> data, Throwable t) {
    }
}

