/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.watermark.WatermarkGRPCInterceptor;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.library.util.FieldsHelper;
import org.apache.skywalking.oap.server.receiver.envoy.AccessLogServiceGRPCHandler;
import org.apache.skywalking.oap.server.receiver.envoy.AccessLogServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverModule;
import org.apache.skywalking.oap.server.receiver.envoy.MetricServiceGRPCHandler;
import org.apache.skywalking.oap.server.receiver.envoy.MetricServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.SatelliteAccessLogServiceGRPCHandlerV3;
import org.apache.skywalking.oap.server.receiver.envoy.TCPOALDefine;

public class EnvoyMetricReceiverProvider
extends ModuleProvider {
    protected EnvoyMetricReceiverConfig config;
    protected GRPCServer grpcServer;
    protected GRPCHandlerRegister receiverGRPCHandlerRegister;
    protected String fieldMappingFile = "metadata-service-mapping.yaml";

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return EnvoyMetricReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<EnvoyMetricReceiverConfig>(){

            public Class type() {
                return EnvoyMetricReceiverConfig.class;
            }

            public void onInitialized(EnvoyMetricReceiverConfig initialized) {
                EnvoyMetricReceiverProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        try {
            FieldsHelper.forClass(this.config.serviceMetaInfoFactory().clazz()).init(this.fieldMappingFile);
        }
        catch (Exception e) {
            throw new ModuleStartException("Failed to load metadata-service-mapping.yaml", (Throwable)e);
        }
        if (this.config.getGRPCPort() != 0 && !RunningMode.isInitMode()) {
            this.grpcServer = this.config.isGRPCSslEnabled() ? new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort(), this.config.getGRPCSslCertChainPath(), this.config.getGRPCSslKeyPath(), this.config.getGRPCSslTrustedCAsPath()) : new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort());
            if (this.config.getMaxMessageSize() > 0) {
                this.grpcServer.setMaxMessageSize(this.config.getMaxMessageSize());
            }
            if (this.config.getMaxConcurrentCallsPerConnection() > 0) {
                this.grpcServer.setMaxConcurrentCallsPerConnection(this.config.getMaxConcurrentCallsPerConnection());
            }
            if (this.config.getGRPCThreadPoolSize() > 0) {
                this.grpcServer.setThreadPoolSize(this.config.getGRPCThreadPoolSize());
            }
            this.grpcServer.initialize();
            this.receiverGRPCHandlerRegister = new GRPCHandlerRegisterImpl(this.grpcServer);
        }
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (!this.config.getAlsTCPAnalysis().isEmpty()) {
            ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)TCPOALDefine.INSTANCE);
        }
        if (this.config.isAcceptMetricsService()) {
            MetricServiceGRPCHandler handler = new MetricServiceGRPCHandler(this.getManager(), this.config);
            GRPCHandlerRegister service = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
            service.addHandler((BindableService)handler);
            service.addHandler((BindableService)new MetricServiceGRPCHandlerV3(handler));
        }
        GRPCHandlerRegister service = Objects.nonNull(this.receiverGRPCHandlerRegister) ? this.receiverGRPCHandlerRegister : (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        AccessLogServiceGRPCHandler handler = new AccessLogServiceGRPCHandler(this.getManager(), this.config);
        service.addHandler((BindableService)handler);
        service.addHandler((BindableService)new AccessLogServiceGRPCHandlerV3(handler));
        service.addHandler((BindableService)new SatelliteAccessLogServiceGRPCHandlerV3(handler));
        service.addFilter((ServerInterceptor)WatermarkGRPCInterceptor.INSTANCE);
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        try {
            if (Objects.nonNull(this.grpcServer) && !RunningMode.isInitMode()) {
                this.grpcServer.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "core", "receiver-sharing-server", "service-mesh"};
    }
}

