/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCServiceLabelQueryDAO
implements IServiceLabelDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<String> queryAllLabels(String serviceId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("service_label");
        ArrayList<String> results = new ArrayList<String>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select label from ").append(table).append(" where ").append("table_name").append(" = ?").append(" and ").append("service_id").append(" = ?");
            condition.add("service_label");
            condition.add(serviceId);
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), this::parseLabels, condition.toArray(new Object[0])));
        }
        return results;
    }

    private List<String> parseLabels(ResultSet resultSet) throws SQLException {
        ArrayList<String> labels = new ArrayList<String>();
        while (resultSet.next()) {
            labels.add(resultSet.getString("label"));
        }
        return labels;
    }

    @Generated
    public JDBCServiceLabelQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

