/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.hierarchy.instance.InstanceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.hierarchy.service.ServiceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.storage.query.IHierarchyQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCEntityConverters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCHierarchyQueryDAO
implements IHierarchyQueryDAO {
    private final JDBCClient jdbcClient;
    private final int queryMaxSize;
    private final TableHelper tableHelper;

    public JDBCHierarchyQueryDAO(JDBCClient jdbcClient, int metadataQueryMaxSize, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.queryMaxSize = metadataQueryMaxSize * 2;
        this.tableHelper = tableHelper;
    }

    public List<ServiceHierarchyRelationTraffic> readAllServiceHierarchyRelations() throws Exception {
        ArrayList results = new ArrayList();
        List<String> tables = this.tableHelper.getTablesWithinTTL("service_hierarchy_relation");
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForReadAllServiceRelations(table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildServiceRelations, sqlAndParameters.parameters()));
        }
        return results.stream().limit(this.queryMaxSize).collect(Collectors.toList());
    }

    public List<InstanceHierarchyRelationTraffic> readInstanceHierarchyRelations(String instanceId, String layer) throws Exception {
        ArrayList<InstanceHierarchyRelationTraffic> results = new ArrayList<InstanceHierarchyRelationTraffic>();
        List<String> tables = this.tableHelper.getTablesWithinTTL("instance_hierarchy_relation");
        int layerValue = Layer.valueOf((String)layer).value();
        ArrayList calls = new ArrayList();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForReadInstanceRelations(table, instanceId, layerValue);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildInstanceRelations, sqlAndParameters.parameters()));
        }
        return results;
    }

    protected SQLAndParameters buildSQLForReadAllServiceRelations(String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(5);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ");
        parameters.add("service_hierarchy_relation");
        sql.append(" limit ").append(this.queryMaxSize);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    protected SQLAndParameters buildSQLForReadInstanceRelations(String table, final String instanceId, final int layerValue) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(5){
            {
                super(initialCapacity);
                this.add("instance_hierarchy_relation");
                this.add(instanceId);
                this.add(layerValue);
                this.add(instanceId);
                this.add(layerValue);
            }
        };
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ").append("and ((").append("instance_id").append("=? and ").append("service_layer").append("=?").append(") or (").append("related_instance_id").append("=? and ").append("related_service_layer").append("=?").append("))");
        return new SQLAndParameters(sql.toString(), (List<Object>)parameters);
    }

    private List<ServiceHierarchyRelationTraffic> buildServiceRelations(ResultSet resultSet) throws SQLException {
        ArrayList<ServiceHierarchyRelationTraffic> relations = new ArrayList<ServiceHierarchyRelationTraffic>();
        while (resultSet.next()) {
            relations.add(new ServiceHierarchyRelationTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet)));
        }
        return relations;
    }

    private List<InstanceHierarchyRelationTraffic> buildInstanceRelations(ResultSet resultSet) throws SQLException {
        ArrayList<InstanceHierarchyRelationTraffic> relations = new ArrayList<InstanceHierarchyRelationTraffic>();
        while (resultSet.next()) {
            relations.add(new InstanceHierarchyRelationTraffic.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet)));
        }
        return relations;
    }
}

