/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCEBPFProfilingTaskDAO
extends JDBCSQLExecutor
implements IEBPFProfilingTaskDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    protected SQLAndParameters buildSQLForQueryTasksByServices(List<String> serviceIdList, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        sql.append("select * from ").append(table);
        StringBuilder conditionSql = new StringBuilder();
        conditionSql.append("table_name").append(" = ?");
        parameters.add("ebpf_profiling_task");
        this.appendListCondition(conditionSql, parameters, "service_id", serviceIdList);
        if (taskStartTime > 0L) {
            this.appendCondition(conditionSql, parameters, "start_time", ">=", taskStartTime);
        }
        if (latestUpdateTime > 0L) {
            this.appendCondition(conditionSql, parameters, "last_update_time", ">", latestUpdateTime);
        }
        if (triggerType != null) {
            this.appendCondition(conditionSql, parameters, "trigger_type", "=", triggerType.value());
        }
        if (conditionSql.length() > 0) {
            sql.append(" where ").append((CharSequence)conditionSql);
        }
        return new SQLAndParameters(sql.toString(), parameters);
    }

    public List<EBPFProfilingTaskRecord> queryTasksByServices(List<String> serviceIdList, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("ebpf_profiling_task");
        ArrayList<EBPFProfilingTaskRecord> results = new ArrayList<EBPFProfilingTaskRecord>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForQueryTasksByServices(serviceIdList, triggerType, taskStartTime, latestUpdateTime, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildTasks, sqlAndParameters.parameters()));
        }
        return results;
    }

    public List<EBPFProfilingTaskRecord> queryTasksByTargets(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targetTypes, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime) throws IOException {
        ArrayList<EBPFProfilingTaskRecord> results = new ArrayList<EBPFProfilingTaskRecord>();
        List<String> tables = this.tableHelper.getTablesWithinTTL("ebpf_profiling_task");
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQLForQueryTasksByTargets(serviceId, serviceInstanceId, targetTypes, triggerType, taskStartTime, latestUpdateTime, table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildTasks, sqlAndParameters.parameters()));
        }
        return results;
    }

    public List<EBPFProfilingTaskRecord> getTaskRecord(String id) throws IOException {
        ArrayList<EBPFProfilingTaskRecord> results = new ArrayList<EBPFProfilingTaskRecord>();
        List<String> tables = this.tableHelper.getTablesWithinTTL("ebpf_profiling_task");
        for (String table : tables) {
            String sql = "select * from " + table + " where table_name = ?logical_id = ?";
            results.addAll((Collection)this.jdbcClient.executeQuery(sql, this::buildTasks, new Object[]{"ebpf_profiling_task", id}));
        }
        return results;
    }

    protected SQLAndParameters buildSQLForQueryTasksByTargets(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targetTypes, EBPFProfilingTriggerType triggerType, long taskStartTime, long latestUpdateTime, String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder conditions = new StringBuilder();
        sql.append("select * from ").append(table);
        conditions.append("table_name").append(" = ?");
        parameters.add("ebpf_profiling_task");
        if (StringUtil.isNotEmpty((String)serviceId)) {
            this.appendCondition(conditions, parameters, "service_id", serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            this.appendCondition(conditions, parameters, "instance_id", serviceInstanceId);
        }
        this.appendListCondition(conditions, parameters, "target_type", targetTypes.stream().map(EBPFProfilingTargetType::value).collect(Collectors.toList()));
        if (taskStartTime > 0L) {
            this.appendCondition(conditions, parameters, "start_time", ">=", taskStartTime);
        }
        if (latestUpdateTime > 0L) {
            this.appendCondition(conditions, parameters, "last_update_time", ">", latestUpdateTime);
        }
        if (triggerType != null) {
            this.appendCondition(conditions, parameters, "trigger_type", "=", triggerType.value());
        }
        if (conditions.length() > 0) {
            sql.append(" where ").append((CharSequence)conditions);
        }
        return new SQLAndParameters(sql.toString(), parameters);
    }

    private List<EBPFProfilingTaskRecord> buildTasks(ResultSet resultSet) throws SQLException {
        StorageData data;
        ArrayList<EBPFProfilingTaskRecord> tasks = new ArrayList<EBPFProfilingTaskRecord>();
        while ((data = this.toStorageData(resultSet, "ebpf_profiling_task", (StorageBuilder<? extends StorageData>)new EBPFProfilingTaskRecord.Builder())) != null) {
            tasks.add((EBPFProfilingTaskRecord)data);
        }
        return tasks;
    }

    private void appendCondition(StringBuilder conditionSql, List<Object> condition, String filed, Object data) {
        this.appendCondition(conditionSql, condition, filed, "=", data);
    }

    private void appendCondition(StringBuilder conditionSql, List<Object> condition, String filed, String compare, Object data) {
        if (conditionSql.length() > 0) {
            conditionSql.append(" and ");
        }
        conditionSql.append(filed).append(compare).append("?");
        condition.add(data);
    }

    private <T> void appendListCondition(StringBuilder conditionSql, List<Object> condition, String filed, List<T> data) {
        if (conditionSql.length() > 0) {
            conditionSql.append(" and ");
        }
        conditionSql.append(filed).append(" in (");
        for (int i = 0; i < data.size(); ++i) {
            if (i > 0) {
                conditionSql.append(",");
            }
            conditionSql.append("?");
        }
        conditionSql.append(")");
        condition.addAll(data);
    }

    @Generated
    public JDBCEBPFProfilingTaskDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

