/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingScheduleRecord;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCEntityConverters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCEBPFProfilingScheduleDAO
implements IEBPFProfilingScheduleDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<EBPFProfilingSchedule> querySchedules(String taskId) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("ebpf_profiling_schedule");
        ArrayList<EBPFProfilingSchedule> schedules = new ArrayList<EBPFProfilingSchedule>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(taskId, table);
            schedules.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), this::buildSchedules, sqlAndParameters.parameters()));
        }
        return schedules;
    }

    protected SQLAndParameters buildSQL(String taskId, String table) {
        StringBuilder sql = new StringBuilder();
        StringBuilder conditions = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(4);
        sql.append("select * from ").append(table);
        conditions.append("table_name").append(" = ?");
        parameters.add("ebpf_profiling_schedule");
        this.appendCondition(conditions, parameters, "task_id", "=", taskId);
        if (conditions.length() > 0) {
            sql.append(" where ").append((CharSequence)conditions);
        }
        return new SQLAndParameters(sql.toString(), parameters);
    }

    private List<EBPFProfilingSchedule> buildSchedules(ResultSet resultSet) throws SQLException {
        ArrayList<EBPFProfilingSchedule> schedules = new ArrayList<EBPFProfilingSchedule>();
        while (resultSet.next()) {
            EBPFProfilingScheduleRecord r = new EBPFProfilingScheduleRecord.Builder().storage2Entity(JDBCEntityConverters.toEntity(resultSet));
            EBPFProfilingSchedule schedule = new EBPFProfilingSchedule();
            schedule.setScheduleId(r.getScheduleId());
            schedule.setTaskId(r.getTaskId());
            schedule.setProcessId(r.getProcessId());
            schedule.setStartTime(r.getStartTime());
            schedule.setEndTime(r.getEndTime());
            schedules.add(schedule);
        }
        return schedules;
    }

    private void appendCondition(StringBuilder conditionSql, List<Object> condition, String filed, String compare, Object data) {
        if (conditionSql.length() > 0) {
            conditionSql.append(" and ");
        }
        conditionSql.append(filed).append(compare).append("?");
        condition.add(data);
    }

    @Generated
    public JDBCEBPFProfilingScheduleDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

