/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.BadRequest;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Help;
import com.google.rpc.LocalizedMessage;
import com.google.rpc.PreconditionFailure;
import com.google.rpc.QuotaFailure;
import com.google.rpc.RequestInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandlerUtil;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import org.curioswitch.common.protobuf.json.MessageMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JsonUnframedGrpcErrorHandler
implements UnframedGrpcErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsonUnframedGrpcErrorHandler.class);
    static final MessageMarshaller ERROR_DETAILS_MARSHALLER = MessageMarshaller.builder().omittingInsignificantWhitespace(true).register((Message)RetryInfo.getDefaultInstance()).register((Message)ErrorInfo.getDefaultInstance()).register((Message)QuotaFailure.getDefaultInstance()).register((Message)DebugInfo.getDefaultInstance()).register((Message)PreconditionFailure.getDefaultInstance()).register((Message)BadRequest.getDefaultInstance()).register((Message)RequestInfo.getDefaultInstance()).register((Message)ResourceInfo.getDefaultInstance()).register((Message)Help.getDefaultInstance()).register((Message)LocalizedMessage.getDefaultInstance()).build();
    private static final UnframedGrpcStatusMappingFunction DEFAULT_STATUS_MAPPING_FUNCTION = UnframedGrpcStatusMappingFunction.of();
    private static final JsonUnframedGrpcErrorHandler DEFAULT = new JsonUnframedGrpcErrorHandler(DEFAULT_STATUS_MAPPING_FUNCTION, ERROR_DETAILS_MARSHALLER);
    private static final ObjectMapper mapper = JacksonUtil.newDefaultObjectMapper();
    private final UnframedGrpcStatusMappingFunction statusMappingFunction;
    private final MessageMarshaller jsonMarshaller;

    static JsonUnframedGrpcErrorHandler of() {
        return DEFAULT;
    }

    static JsonUnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        return JsonUnframedGrpcErrorHandler.of(statusMappingFunction, ERROR_DETAILS_MARSHALLER);
    }

    static JsonUnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction statusMappingFunction, MessageMarshaller jsonMarshaller) {
        if (DEFAULT_STATUS_MAPPING_FUNCTION == statusMappingFunction && ERROR_DETAILS_MARSHALLER == jsonMarshaller) {
            return DEFAULT;
        }
        return new JsonUnframedGrpcErrorHandler(statusMappingFunction, jsonMarshaller);
    }

    private JsonUnframedGrpcErrorHandler(UnframedGrpcStatusMappingFunction statusMappingFunction, MessageMarshaller jsonMarshaller) {
        this.statusMappingFunction = UnframedGrpcErrorHandlerUtil.withDefault(statusMappingFunction);
        this.jsonMarshaller = jsonMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse handle(ServiceRequestContext ctx, Status status, AggregatedHttpResponse response) {
        ByteBuf buffer = ctx.alloc().buffer();
        Status.Code grpcCode = status.getCode();
        String grpcMessage = status.getDescription();
        Throwable cause = UnframedGrpcErrorHandlerUtil.responseCause(ctx);
        HttpStatus httpStatus = this.statusMappingFunction.apply(ctx, status, cause);
        assert (httpStatus != null) : "Default statusMappingFunction returned null?";
        HttpHeaders trailers = !response.trailers().isEmpty() ? response.trailers() : response.headers();
        String grpcStatusDetailsBin = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS_DETAILS_BIN);
        ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.JSON_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
        boolean success = false;
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
             JsonGenerator jsonGenerator = mapper.createGenerator((OutputStream)outputStream);){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("code", grpcCode.value());
            jsonGenerator.writeStringField("grpc-code", grpcCode.name());
            if (grpcMessage != null) {
                jsonGenerator.writeStringField("message", grpcMessage);
            }
            if (cause != null && ctx.config().verboseResponses()) {
                jsonGenerator.writeStringField("stack-trace", Exceptions.traceText((Throwable)cause));
            }
            if (!Strings.isNullOrEmpty((String)grpcStatusDetailsBin)) {
                com.google.rpc.Status rpcStatus = null;
                try {
                    rpcStatus = JsonUnframedGrpcErrorHandler.decodeGrpcStatusDetailsBin(grpcStatusDetailsBin);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.warn("Unexpected exception while decoding grpc-status-details-bin: {}", (Object)grpcStatusDetailsBin, (Object)e);
                }
                if (rpcStatus != null) {
                    jsonGenerator.writeFieldName("details");
                    this.writeErrorDetails(ctx, rpcStatus.getDetailsList(), jsonGenerator);
                }
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
            success = true;
        }
        catch (IOException e) {
            logger.warn("{} Unexpected exception while generating a JSON response", (Object)ctx, (Object)e);
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        if (success) {
            return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)HttpData.wrap((ByteBuf)buffer));
        }
        return HttpResponse.of((ResponseHeaders)responseHeaders);
    }

    @VisibleForTesting
    void writeErrorDetails(ServiceRequestContext ctx, List<Any> details, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (Any detail : details) {
            try {
                this.jsonMarshaller.writeValue((Message)detail, jsonGenerator);
            }
            catch (IOException e) {
                logger.warn("Unexpected exception while writing an error detail to JSON. ctx: '{}', detail: '{}'", new Object[]{ctx, detail, e});
            }
        }
        jsonGenerator.writeEndArray();
    }

    @VisibleForTesting
    static com.google.rpc.Status decodeGrpcStatusDetailsBin(String grpcStatusDetailsBin) throws InvalidProtocolBufferException {
        byte[] result = Base64.getDecoder().decode(grpcStatusDetailsBin);
        return com.google.rpc.Status.parseFrom((byte[])result);
    }
}

