/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.grpc.GrpcHealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthCheckUpdateListener;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class GrpcHealthCheckServiceBuilder {
    private final ImmutableSet.Builder<ListenableHealthChecker> serverHealthCheckers = ImmutableSet.builder();
    private final ImmutableMap.Builder<String, ListenableHealthChecker> grpcHealthCheckers = ImmutableMap.builder();
    private final ImmutableList.Builder<HealthCheckUpdateListener> updateListeners = ImmutableList.builder();

    GrpcHealthCheckServiceBuilder() {
    }

    public GrpcHealthCheckServiceBuilder checkers(ListenableHealthChecker ... serverHealthCheckers) {
        return this.checkers((Iterable<? extends ListenableHealthChecker>)ImmutableSet.copyOf((Object[])Objects.requireNonNull(serverHealthCheckers, "healthCheckers")));
    }

    public GrpcHealthCheckServiceBuilder checkers(Iterable<? extends ListenableHealthChecker> serverHealthCheckers) {
        this.serverHealthCheckers.addAll(Objects.requireNonNull(serverHealthCheckers, "healthCheckers"));
        return this;
    }

    public GrpcHealthCheckServiceBuilder serviceCheckers(String serviceName, ListenableHealthChecker healthChecker) {
        this.grpcHealthCheckers.put((Object)Objects.requireNonNull(serviceName, "serviceName"), (Object)Objects.requireNonNull(healthChecker, "healthChecker"));
        return this;
    }

    public GrpcHealthCheckServiceBuilder updateListener(HealthCheckUpdateListener updateListener) {
        this.updateListeners.add((Object)Objects.requireNonNull(updateListener, "updateListener"));
        return this;
    }

    public GrpcHealthCheckService build() {
        return new GrpcHealthCheckService((Set<ListenableHealthChecker>)this.serverHealthCheckers.build(), (Map<String, ListenableHealthChecker>)this.grpcHealthCheckers.build(), (List<HealthCheckUpdateListener>)this.updateListeners.build());
    }
}

