/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.linecorp.armeria.common.grpc.StackTraceElementProto;
import com.linecorp.armeria.common.grpc.ThrowableProto;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import java.util.Objects;

public final class StatusCauseException
extends RuntimeException {
    private static final long serialVersionUID = -1792808536714102039L;
    private final String originalClassName;
    private final String originalMessage;

    public StatusCauseException(ThrowableProto proto) {
        super(Objects.requireNonNull(proto, "proto").getOriginalClassName() + ": " + proto.getOriginalMessage());
        this.originalClassName = proto.getOriginalClassName();
        this.originalMessage = proto.getOriginalMessage();
        if (proto.getStackTraceCount() > 0) {
            this.setStackTrace((StackTraceElement[])proto.getStackTraceList().stream().map(StatusCauseException::deserializeStackTraceElement).toArray(StackTraceElement[]::new));
        }
        if (proto.hasCause()) {
            this.initCause(new StatusCauseException(proto.getCause()));
        }
    }

    public String getOriginalClassName() {
        return this.originalClassName;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    private static StackTraceElement deserializeStackTraceElement(StackTraceElementProto proto) {
        return new StackTraceElement(proto.getClassName(), proto.getMethodName(), Strings.emptyToNull((String)proto.getFileName()), proto.getLineNumber());
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

