/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public final class GrpcSerializationFormats {
    public static final SerializationFormat PROTO = SerializationFormat.of((String)"gproto");
    public static final SerializationFormat JSON = SerializationFormat.of((String)"gjson");
    public static final SerializationFormat PROTO_WEB = SerializationFormat.of((String)"gproto-web");
    public static final SerializationFormat JSON_WEB = SerializationFormat.of((String)"gjson-web");
    public static final SerializationFormat PROTO_WEB_TEXT = SerializationFormat.of((String)"gproto-web-text");
    private static final Set<SerializationFormat> GRPC_FORMATS = ImmutableSet.of((Object)PROTO, (Object)JSON, (Object)PROTO_WEB, (Object)JSON_WEB, (Object)PROTO_WEB_TEXT);

    public static Set<SerializationFormat> values() {
        return GRPC_FORMATS;
    }

    public static boolean isGrpc(SerializationFormat format) {
        return GrpcSerializationFormats.values().contains(Objects.requireNonNull(format, "format"));
    }

    public static boolean isProto(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == PROTO || format == PROTO_WEB || format == PROTO_WEB_TEXT;
    }

    public static boolean isJson(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == JSON || format == JSON_WEB;
    }

    public static boolean isGrpcWeb(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == PROTO_WEB || format == JSON_WEB || format == PROTO_WEB_TEXT;
    }

    public static boolean isGrpcWebText(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == PROTO_WEB_TEXT;
    }

    private GrpcSerializationFormats() {
    }
}

